/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.ra;

import java.io.PrintWriter;
import java.util.Set;
import javax.jms.ConnectionMetaData;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.security.auth.Subject;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.jms.client.JBossConnectionFactory;
import org.jboss.messaging.ra.JBMConnectionFactoryImpl;
import org.jboss.messaging.ra.JBMConnectionManager;
import org.jboss.messaging.ra.JBMConnectionMetaData;
import org.jboss.messaging.ra.JBMConnectionRequestInfo;
import org.jboss.messaging.ra.JBMCredential;
import org.jboss.messaging.ra.JBMMCFProperties;
import org.jboss.messaging.ra.JBMManagedConnection;
import org.jboss.messaging.ra.JBMResourceAdapter;

public class JBMManagedConnectionFactory
implements ManagedConnectionFactory,
ResourceAdapterAssociation {
    static final long serialVersionUID = -1452379518562456741L;
    private static final Logger log = Logger.getLogger(JBMManagedConnectionFactory.class);
    private static boolean trace = log.isTraceEnabled();
    private JBMResourceAdapter ra;
    private ConnectionManager cm;
    private final JBMMCFProperties mcfProperties;
    private JBossConnectionFactory connectionFactory;

    public JBMManagedConnectionFactory() {
        if (trace) {
            log.trace((Object)"constructor()");
        }
        this.ra = null;
        this.cm = null;
        this.mcfProperties = new JBMMCFProperties();
    }

    public Object createConnectionFactory() throws ResourceException {
        if (trace) {
            log.debug((Object)"createConnectionFactory()");
        }
        return this.createConnectionFactory(new JBMConnectionManager());
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        if (trace) {
            log.trace((Object)("createConnectionFactory(" + cxManager + ")"));
        }
        this.cm = cxManager;
        JBMConnectionFactoryImpl cf = new JBMConnectionFactoryImpl(this, this.cm);
        if (trace) {
            log.trace((Object)("Created connection factory: " + cf + ", using connection manager: " + this.cm));
        }
        return cf;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (trace) {
            log.trace((Object)("createManagedConnection(" + subject + ", " + cxRequestInfo + ")"));
        }
        JBMConnectionRequestInfo cri = this.getCRI((JBMConnectionRequestInfo)cxRequestInfo);
        JBMCredential credential = JBMCredential.getCredential(this, subject, cri);
        if (trace) {
            log.trace((Object)("jms credential: " + credential));
        }
        JBMManagedConnection mc = new JBMManagedConnection(this, cri, credential.getUserName(), credential.getPassword());
        if (trace) {
            log.trace((Object)("created new managed connection: " + mc));
        }
        return mc;
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (trace) {
            log.trace((Object)("matchManagedConnections(" + connectionSet + ", " + subject + ", " + cxRequestInfo + ")"));
        }
        JBMConnectionRequestInfo cri = this.getCRI((JBMConnectionRequestInfo)cxRequestInfo);
        JBMCredential credential = JBMCredential.getCredential(this, subject, cri);
        if (trace) {
            log.trace((Object)("Looking for connection matching credentials: " + credential));
        }
        for (Object obj : connectionSet) {
            if (!(obj instanceof JBMManagedConnection)) continue;
            JBMManagedConnection mc = (JBMManagedConnection)obj;
            JBMManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (mc.getUserName() != null && (mc.getUserName() == null || !mc.getUserName().equals(credential.getUserName())) || !((Object)mcf).equals(this) || !cri.equals(mc.getCRI())) continue;
            if (trace) {
                log.trace((Object)("Found matching connection: " + mc));
            }
            return mc;
        }
        if (trace) {
            log.trace((Object)"No matching connection was found");
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        if (trace) {
            log.trace((Object)("setLogWriter(" + out + ")"));
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (trace) {
            log.trace((Object)"getLogWriter()");
        }
        return null;
    }

    public ResourceAdapter getResourceAdapter() {
        if (trace) {
            log.trace((Object)"getResourceAdapter()");
        }
        return this.ra;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        if (trace) {
            log.trace((Object)("setResourceAdapter(" + ra + ")"));
        }
        if (ra == null || !(ra instanceof JBMResourceAdapter)) {
            throw new ResourceException("Resource adapter is " + ra);
        }
        this.ra = (JBMResourceAdapter)ra;
    }

    public boolean equals(Object obj) {
        if (trace) {
            log.trace((Object)("equals(" + obj + ")"));
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof JBMManagedConnectionFactory) {
            JBMManagedConnectionFactory other = (JBMManagedConnectionFactory)obj;
            return this.mcfProperties.equals(other.getProperties()) && this.ra.equals(other.getResourceAdapter());
        }
        return false;
    }

    public int hashCode() {
        if (trace) {
            log.trace((Object)"hashCode()");
        }
        int hash = this.mcfProperties.hashCode();
        return hash += 31 * this.ra.hashCode();
    }

    public String getSessionDefaultType() {
        if (trace) {
            log.trace((Object)"getSessionDefaultType()");
        }
        return this.mcfProperties.getSessionDefaultType();
    }

    public void setSessionDefaultType(String type) {
        if (trace) {
            log.trace((Object)("setSessionDefaultType(" + type + ")"));
        }
        this.mcfProperties.setSessionDefaultType(type);
    }

    public String getConnectionParameters() {
        return this.mcfProperties.getConnectionParameters();
    }

    public void setConnectionParameters(String configuration) {
        this.mcfProperties.setConnectionParameters(configuration);
    }

    public String getConnectorClassName() {
        return this.mcfProperties.getConnectorClassName();
    }

    public void setConnectorClassName(String value) {
        this.mcfProperties.setConnectorClassName(value);
    }

    public Integer getUseTryLock() {
        if (trace) {
            log.trace((Object)"getUseTryLock()");
        }
        return this.mcfProperties.getUseTryLock();
    }

    public void setUseTryLock(Integer useTryLock) {
        if (trace) {
            log.trace((Object)("setUseTryLock(" + useTryLock + ")"));
        }
        this.mcfProperties.setUseTryLock(useTryLock);
    }

    public ConnectionMetaData getMetaData() {
        if (trace) {
            log.trace((Object)"getMetadata()");
        }
        return new JBMConnectionMetaData();
    }

    protected synchronized JBossConnectionFactory getJBossConnectionFactory() throws ResourceException {
        if (this.mcfProperties.getConnectorClassName() != null) {
            if (this.connectionFactory == null) {
                this.connectionFactory = this.ra.createRemoteFactory(this.mcfProperties.getConnectorClassName(), this.mcfProperties.getParsedConnectionParameters());
            }
            return this.connectionFactory;
        }
        return this.ra.getJBossConnectionFactory();
    }

    protected JBMMCFProperties getProperties() {
        if (trace) {
            log.trace((Object)"getProperties()");
        }
        return this.mcfProperties;
    }

    private JBMConnectionRequestInfo getCRI(JBMConnectionRequestInfo info) {
        if (trace) {
            log.trace((Object)("getCRI(" + info + ")"));
        }
        if (info == null) {
            return new JBMConnectionRequestInfo(this.ra.getProperties(), this.mcfProperties.getType());
        }
        info.setDefaults(this.ra.getProperties());
        return info;
    }
}

