/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.ra.inflow;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionManager;
import org.jboss.messaging.core.client.ClientSession;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.jms.JBossDestination;
import org.jboss.messaging.jms.JBossQueue;
import org.jboss.messaging.jms.JBossTopic;
import org.jboss.messaging.jms.client.JBossConnectionFactory;
import org.jboss.messaging.ra.JBMResourceAdapter;
import org.jboss.messaging.ra.Util;
import org.jboss.messaging.ra.inflow.JBMActivationSpec;
import org.jboss.messaging.ra.inflow.JBMMessageHandler;
import org.jboss.messaging.utils.SimpleString;
import org.jboss.tm.TransactionManagerLocator;

public class JBMActivation {
    private static final Logger log = Logger.getLogger(JBMActivation.class);
    private static boolean trace = log.isTraceEnabled();
    public static final Method ONMESSAGE;
    private final JBMResourceAdapter ra;
    private final JBMActivationSpec spec;
    private final MessageEndpointFactory endpointFactory;
    private final AtomicBoolean deliveryActive = new AtomicBoolean(false);
    private boolean isTopic = false;
    private boolean isDeliveryTransacted;
    private JBossDestination destination;
    private TransactionManager tm;
    private final List<JBMMessageHandler> handlers = new ArrayList<JBMMessageHandler>();
    private JBossConnectionFactory factory;

    public JBMActivation(JBMResourceAdapter ra, MessageEndpointFactory endpointFactory, JBMActivationSpec spec) throws ResourceException {
        if (trace) {
            log.trace((Object)("constructor(" + ra + ", " + endpointFactory + ", " + spec + ")"));
        }
        this.ra = ra;
        this.endpointFactory = endpointFactory;
        this.spec = spec;
        try {
            this.isDeliveryTransacted = endpointFactory.isDeliveryTransacted(ONMESSAGE);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public JBMActivationSpec getActivationSpec() {
        if (trace) {
            log.trace((Object)"getActivationSpec()");
        }
        return this.spec;
    }

    public MessageEndpointFactory getMessageEndpointFactory() {
        if (trace) {
            log.trace((Object)"getMessageEndpointFactory()");
        }
        return this.endpointFactory;
    }

    public boolean isDeliveryTransacted() {
        if (trace) {
            log.trace((Object)"isDeliveryTransacted()");
        }
        return this.isDeliveryTransacted;
    }

    public WorkManager getWorkManager() {
        if (trace) {
            log.trace((Object)"getWorkManager()");
        }
        return this.ra.getWorkManager();
    }

    public TransactionManager getTransactionManager() {
        if (trace) {
            log.trace((Object)"getTransactionManager()");
        }
        if (this.tm == null) {
            this.tm = TransactionManagerLocator.locateTransactionManager();
        }
        return this.tm;
    }

    public boolean isTopic() {
        if (trace) {
            log.trace((Object)"isTopic()");
        }
        return this.isTopic;
    }

    public void start() throws ResourceException {
        if (trace) {
            log.trace((Object)"start()");
        }
        try {
            this.setup();
        }
        catch (Exception e) {
            throw new ResourceException("unable to start Activation", (Throwable)e);
        }
        this.deliveryActive.set(true);
    }

    public void stop() {
        if (trace) {
            log.trace((Object)"stop()");
        }
        this.deliveryActive.set(false);
        this.teardown();
    }

    protected void setup() throws Exception {
        log.debug((Object)("Setting up " + this.spec));
        this.setupCF();
        this.setupDestination();
        for (int i = 0; i < this.spec.getMaxSessionInt(); ++i) {
            ClientSession session = this.setupSession();
            JBMMessageHandler handler = new JBMMessageHandler(this, session);
            handler.setup();
            session.start();
            this.handlers.add(handler);
        }
        log.debug((Object)("Setup complete " + this));
    }

    protected void teardown() {
        log.debug((Object)("Tearing down " + this.spec));
        for (JBMMessageHandler handler : this.handlers) {
            handler.teardown();
        }
        log.debug((Object)("Tearing down complete " + this));
    }

    protected void setupCF() throws Exception {
        this.factory = this.spec.getConnectorClassName() == null ? this.ra.getJBossConnectionFactory() : this.ra.createRemoteFactory(this.spec.getConnectorClassName(), this.spec.getParsedConnectionParameters());
    }

    protected ClientSession setupSession() throws Exception {
        ClientSession result = null;
        try {
            result = this.ra.createSession(this.factory.getCoreFactory(), this.spec.getAcknowledgeModeInt(), this.spec.getUser(), this.spec.getPassword(), this.ra.getPreAcknowledge(), this.ra.getDupsOKBatchSize(), this.ra.getTransactionBatchSize(), this.isDeliveryTransacted);
            log.debug((Object)("Using queue connection " + result));
            return result;
        }
        catch (Throwable t) {
            try {
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception e) {
                log.trace((Object)"Ignored error closing connection", (Throwable)e);
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new RuntimeException("Error configuring connection", t);
        }
    }

    public SimpleString getAddress() {
        return this.destination.getSimpleAddress();
    }

    protected void setupDestination() throws Exception {
        String destinationName;
        block12: {
            destinationName = this.spec.getDestination();
            if (this.spec.isUseJNDI()) {
                String destinationTypeString;
                InitialContext ctx = new InitialContext();
                log.debug((Object)("Using context " + ctx.getEnvironment() + " for " + this.spec));
                if (trace) {
                    log.trace((Object)("setupDestination(" + ctx + ")"));
                }
                if ((destinationTypeString = this.spec.getDestinationType()) != null && !destinationTypeString.trim().equals("")) {
                    Class<Topic> destinationType;
                    log.debug((Object)("Destination type defined as " + destinationTypeString));
                    if (Topic.class.getName().equals(destinationTypeString)) {
                        destinationType = Topic.class;
                        this.isTopic = true;
                    } else {
                        destinationType = Queue.class;
                    }
                    log.debug((Object)("Retrieving destination " + destinationName + " of type " + destinationType.getName()));
                    try {
                        this.destination = (JBossDestination)Util.lookup(ctx, destinationName, destinationType);
                    }
                    catch (Exception e) {
                        if (destinationName == null) {
                            throw e;
                        }
                        if (this.isTopic) {
                            this.destination = new JBossTopic(destinationName.substring(destinationName.lastIndexOf(47) + 1));
                            break block12;
                        }
                        this.destination = new JBossQueue(destinationName.substring(destinationName.lastIndexOf(47) + 1));
                    }
                } else {
                    log.debug((Object)"Destination type not defined");
                    log.debug((Object)("Retrieving destination " + destinationName + " of type " + Destination.class.getName()));
                    this.destination = (JBossDestination)Util.lookup(ctx, destinationName, Destination.class);
                    if (this.destination instanceof Topic) {
                        this.isTopic = true;
                    }
                }
            } else {
                this.destination = Topic.class.getName().equals(this.spec.getDestinationType()) ? new JBossTopic(this.spec.getDestination()) : new JBossQueue(this.spec.getDestination());
            }
        }
        log.debug((Object)("Got destination " + this.destination + " from " + destinationName));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(JBMActivation.class.getName()).append('(');
        buffer.append("spec=").append(this.spec.getClass().getName());
        buffer.append(" mepf=").append(this.endpointFactory.getClass().getName());
        buffer.append(" active=").append(this.deliveryActive.get());
        if (this.spec.getDestination() != null) {
            buffer.append(" destination=").append(this.spec.getDestination());
        }
        buffer.append(" transacted=").append(this.isDeliveryTransacted);
        buffer.append(')');
        return buffer.toString();
    }

    static {
        try {
            ONMESSAGE = MessageListener.class.getMethod("onMessage", Message.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

