/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.ra;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;
import org.jboss.messaging.core.client.ClientSession;
import org.jboss.messaging.core.client.ClientSessionFactory;
import org.jboss.messaging.core.config.TransportConfiguration;
import org.jboss.messaging.core.exception.MessagingException;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.jms.client.JBossConnectionFactory;
import org.jboss.messaging.ra.JBMRAProperties;
import org.jboss.messaging.ra.Util;
import org.jboss.messaging.ra.inflow.JBMActivation;
import org.jboss.messaging.ra.inflow.JBMActivationSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBMResourceAdapter
implements ResourceAdapter {
    private static final Logger log = Logger.getLogger(JBMResourceAdapter.class);
    private static boolean trace = log.isTraceEnabled();
    private BootstrapContext ctx;
    private final JBMRAProperties raProperties;
    private ClientSessionFactory sessionFactory;
    private final AtomicBoolean configured;
    private final Map<ActivationSpec, JBMActivation> activations;
    private JBossConnectionFactory jBossConnectionFactory;

    public JBMResourceAdapter() {
        if (trace) {
            log.trace((Object)"constructor()");
        }
        this.raProperties = new JBMRAProperties();
        this.sessionFactory = null;
        this.configured = new AtomicBoolean(false);
        this.activations = new ConcurrentHashMap<ActivationSpec, JBMActivation>();
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        if (!this.configured.getAndSet(true)) {
            try {
                this.setup();
            }
            catch (MessagingException e) {
                throw new ResourceException("Unable to create activation", (Throwable)e);
            }
        }
        if (trace) {
            log.trace((Object)("endpointActivation(" + endpointFactory + ", " + spec + ")"));
        }
        JBMActivation activation = new JBMActivation(this, endpointFactory, (JBMActivationSpec)spec);
        this.activations.put(spec, activation);
        activation.start();
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        JBMActivation activation;
        if (trace) {
            log.trace((Object)("endpointDeactivation(" + endpointFactory + ", " + spec + ")"));
        }
        if ((activation = this.activations.remove(spec)) != null) {
            activation.stop();
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        if (trace) {
            log.trace((Object)("getXAResources(" + specs + ")"));
        }
        throw new ResourceException("Unsupported");
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        if (trace) {
            log.trace((Object)("start(" + ctx + ")"));
        }
        this.ctx = ctx;
        log.info((Object)"JBoss Messaging resource adaptor started");
    }

    public void stop() {
        if (trace) {
            log.trace((Object)"stop()");
        }
        for (Map.Entry<ActivationSpec, JBMActivation> entry : this.activations.entrySet()) {
            try {
                entry.getValue().stop();
            }
            catch (Exception ignored) {
                log.debug((Object)"Ignored", (Throwable)ignored);
            }
        }
        this.activations.clear();
        log.info((Object)"JBoss Messaging resource adapter stopped");
    }

    public void setConnectorClassName(String connectorClassName) {
        if (trace) {
            log.trace((Object)("setTransportType(" + connectorClassName + ")"));
        }
        this.raProperties.setConnectorClassName(connectorClassName);
    }

    public String getConnectorClassName() {
        return this.raProperties.getConnectorClassName();
    }

    public Map<String, Object> getConnectionParameters() {
        return this.raProperties.getConnectionParameters();
    }

    public void setConnectionParameters(String config) {
        if (config != null) {
            this.raProperties.setConnectionParameters(Util.parseConfig(config));
        }
    }

    public String getBackupConnectorClassName() {
        return this.raProperties.getBackupConnectorClassName();
    }

    public void setBackupConnectorClassName(String backupConnector) {
        if (trace) {
            log.trace((Object)("setBackUpTransportType(" + backupConnector + ")"));
        }
        this.raProperties.setBackupConnectorClassName(backupConnector);
    }

    public Map<String, Object> getBackupConnectionParameters() {
        return this.raProperties.getBackupConnectionParameters();
    }

    public void setBackupTransportConfiguration(String config) {
        if (config != null) {
            this.raProperties.setBackupConnectionParameters(Util.parseConfig(config));
        }
    }

    public String getDiscoveryGroupAddress() {
        if (trace) {
            log.trace((Object)"getDiscoveryGroupAddress()");
        }
        return this.raProperties.getDiscoveryGroupAddress();
    }

    public void setDiscoveryGroupAddress(String dgn) {
        if (trace) {
            log.trace((Object)("setDiscoveryGroupAddress(" + dgn + ")"));
        }
        this.raProperties.setDiscoveryGroupAddress(dgn);
    }

    public Integer getDiscoveryGroupPort() {
        if (trace) {
            log.trace((Object)"getDiscoveryGroupPort()");
        }
        return this.raProperties.getDiscoveryGroupPort();
    }

    public void setDiscoveryGroupPort(Integer dgp) {
        if (trace) {
            log.trace((Object)("setDiscoveryGroupPort(" + dgp + ")"));
        }
        this.raProperties.setDiscoveryGroupPort(dgp);
    }

    public Long getDiscoveryRefreshTimeout() {
        if (trace) {
            log.trace((Object)"getDiscoveryRefreshTimeout()");
        }
        return this.raProperties.getDiscoveryRefreshTimeout();
    }

    public void setDiscoveryRefreshTimeout(Long discoveryRefreshTimeout) {
        if (trace) {
            log.trace((Object)("setDiscoveryRefreshTimeout(" + discoveryRefreshTimeout + ")"));
        }
        this.raProperties.setDiscoveryRefreshTimeout(discoveryRefreshTimeout);
    }

    public Long getDiscoveryInitialWaitTimeout() {
        if (trace) {
            log.trace((Object)"getDiscoveryInitialWaitTimeout()");
        }
        return this.raProperties.getDiscoveryInitialWaitTimeout();
    }

    public void setDiscoveryInitialWaitTimeout(Long discoveryInitialWaitTimeout) {
        if (trace) {
            log.trace((Object)("setDiscoveryInitialWaitTimeout(" + discoveryInitialWaitTimeout + ")"));
        }
        this.raProperties.setDiscoveryInitialWaitTimeout(discoveryInitialWaitTimeout);
    }

    public String getLoadBalancingPolicyClassName() {
        if (trace) {
            log.trace((Object)"getLoadBalancingPolicyClassName()");
        }
        return this.raProperties.getConnectionLoadBalancingPolicyClassName();
    }

    public void setLoadBalancingPolicyClassName(String loadBalancingPolicyClassName) {
        if (trace) {
            log.trace((Object)("setLoadBalancingPolicyClassName(" + loadBalancingPolicyClassName + ")"));
        }
        this.raProperties.setConnectionLoadBalancingPolicyClassName(loadBalancingPolicyClassName);
    }

    public Long getClientFailureCheckPeriod() {
        if (trace) {
            log.trace((Object)"getClientFailureCheckPeriod()");
        }
        return this.raProperties.getClientFailureCheckPeriod();
    }

    public void setClientFailureCheckPeriod(Long clientFailureCheckPeriod) {
        if (trace) {
            log.trace((Object)("setClientFailureCheckPeriod(" + clientFailureCheckPeriod + ")"));
        }
        this.raProperties.setClientFailureCheckPeriod(clientFailureCheckPeriod);
    }

    public Long getConnectionTTL() {
        if (trace) {
            log.trace((Object)"getConnectionTTL()");
        }
        return this.raProperties.getConnectionTTL();
    }

    public void setConnectionTTL(Long connectionTTL) {
        if (trace) {
            log.trace((Object)("setConnectionTTL(" + connectionTTL + ")"));
        }
        this.raProperties.setConnectionTTL(connectionTTL);
    }

    public Long getCallTimeout() {
        if (trace) {
            log.trace((Object)"getCallTimeout()");
        }
        return this.raProperties.getCallTimeout();
    }

    public void setCallTimeout(Long callTimeout) {
        if (trace) {
            log.trace((Object)("setCallTimeout(" + callTimeout + ")"));
        }
        this.raProperties.setCallTimeout(callTimeout);
    }

    public Integer getDupsOKBatchSize() {
        if (trace) {
            log.trace((Object)"getDupsOKBatchSize()");
        }
        return this.raProperties.getDupsOKBatchSize();
    }

    public void setDupsOKBatchSize(Integer dupsOKBatchSize) {
        if (trace) {
            log.trace((Object)("setDupsOKBatchSize(" + dupsOKBatchSize + ")"));
        }
        this.raProperties.setDupsOKBatchSize(dupsOKBatchSize);
    }

    public Integer getTransactionBatchSize() {
        if (trace) {
            log.trace((Object)"getTransactionBatchSize()");
        }
        return this.raProperties.getTransactionBatchSize();
    }

    public void setTransactionBatchSize(Integer transactionBatchSize) {
        if (trace) {
            log.trace((Object)("setTransactionBatchSize(" + transactionBatchSize + ")"));
        }
        this.raProperties.setTransactionBatchSize(transactionBatchSize);
    }

    public Integer getConsumerWindowSize() {
        if (trace) {
            log.trace((Object)"getConsumerWindowSize()");
        }
        return this.raProperties.getConsumerWindowSize();
    }

    public void setConsumerWindowSize(Integer consumerWindowSize) {
        if (trace) {
            log.trace((Object)("setConsumerWindowSize(" + consumerWindowSize + ")"));
        }
        this.raProperties.setConsumerWindowSize(consumerWindowSize);
    }

    public Integer getConsumerMaxRate() {
        if (trace) {
            log.trace((Object)"getConsumerMaxRate()");
        }
        return this.raProperties.getConsumerMaxRate();
    }

    public void setConsumerMaxRate(Integer consumerMaxRate) {
        if (trace) {
            log.trace((Object)("setConsumerMaxRate(" + consumerMaxRate + ")"));
        }
        this.raProperties.setConsumerMaxRate(consumerMaxRate);
    }

    public Integer getProducerWindowSize() {
        if (trace) {
            log.trace((Object)"getProducerWindowSize()");
        }
        return this.raProperties.getProducerWindowSize();
    }

    public void setProducerWindowSize(Integer producerWindowSize) {
        if (trace) {
            log.trace((Object)("setProducerWindowSize(" + producerWindowSize + ")"));
        }
        this.raProperties.setProducerWindowSize(producerWindowSize);
    }

    public Integer getProducerMaxRate() {
        if (trace) {
            log.trace((Object)"getProducerMaxRate()");
        }
        return this.raProperties.getProducerMaxRate();
    }

    public void setProducerMaxRate(Integer producerMaxRate) {
        if (trace) {
            log.trace((Object)("setProducerMaxRate(" + producerMaxRate + ")"));
        }
        this.raProperties.setProducerMaxRate(producerMaxRate);
    }

    public Integer getMinLargeMessageSize() {
        if (trace) {
            log.trace((Object)"getMinLargeMessageSize()");
        }
        return this.raProperties.getMinLargeMessageSize();
    }

    public void setMinLargeMessageSize(Integer minLargeMessageSize) {
        if (trace) {
            log.trace((Object)("setMinLargeMessageSize(" + minLargeMessageSize + ")"));
        }
        this.raProperties.setMinLargeMessageSize(minLargeMessageSize);
    }

    public Boolean getBlockOnAcknowledge() {
        if (trace) {
            log.trace((Object)"getBlockOnAcknowledge()");
        }
        return this.raProperties.getBlockOnAcknowledge();
    }

    public void setBlockOnAcknowledge(Boolean blockOnAcknowledge) {
        if (trace) {
            log.trace((Object)("setBlockOnAcknowledge(" + blockOnAcknowledge + ")"));
        }
        this.raProperties.setBlockOnAcknowledge(blockOnAcknowledge);
    }

    public Boolean getBlockOnNonPersistentSend() {
        if (trace) {
            log.trace((Object)"getBlockOnNonPersistentSend()");
        }
        return this.raProperties.getBlockOnNonPersistentSend();
    }

    public void setBlockOnNonPersistentSend(Boolean blockOnNonPersistentSend) {
        if (trace) {
            log.trace((Object)("setBlockOnNonPersistentSend(" + blockOnNonPersistentSend + ")"));
        }
        this.raProperties.setBlockOnNonPersistentSend(blockOnNonPersistentSend);
    }

    public Boolean getBlockOnPersistentSend() {
        if (trace) {
            log.trace((Object)"getBlockOnPersistentSend()");
        }
        return this.raProperties.getBlockOnPersistentSend();
    }

    public void setBlockOnPersistentSend(Boolean blockOnPersistentSend) {
        if (trace) {
            log.trace((Object)("setBlockOnPersistentSend(" + blockOnPersistentSend + ")"));
        }
        this.raProperties.setBlockOnPersistentSend(blockOnPersistentSend);
    }

    public Boolean getAutoGroup() {
        if (trace) {
            log.trace((Object)"getAutoGroup()");
        }
        return this.raProperties.getAutoGroup();
    }

    public void setAutoGroup(Boolean autoGroup) {
        if (trace) {
            log.trace((Object)("setAutoGroup(" + autoGroup + ")"));
        }
        this.raProperties.setAutoGroup(autoGroup);
    }

    public Integer getMaxConnections() {
        if (trace) {
            log.trace((Object)"getMaxConnections()");
        }
        return this.raProperties.getMaxConnections();
    }

    public void setMaxConnections(Integer maxConnections) {
        if (trace) {
            log.trace((Object)("setMaxConnections(" + maxConnections + ")"));
        }
        this.raProperties.setMaxConnections(maxConnections);
    }

    public Boolean getPreAcknowledge() {
        if (trace) {
            log.trace((Object)"getPreAcknowledge()");
        }
        return this.raProperties.getPreAcknowledge();
    }

    public void setPreAcknowledge(Boolean preAcknowledge) {
        if (trace) {
            log.trace((Object)("setPreAcknowledge(" + preAcknowledge + ")"));
        }
        this.raProperties.setPreAcknowledge(preAcknowledge);
    }

    public Long getRetryInterval() {
        if (trace) {
            log.trace((Object)"getRetryInterval()");
        }
        return this.raProperties.getRetryInterval();
    }

    public void setRetryInterval(Long retryInterval) {
        if (trace) {
            log.trace((Object)("setRetryInterval(" + retryInterval + ")"));
        }
        this.raProperties.setRetryInterval(retryInterval);
    }

    public Double getRetryIntervalMultiplier() {
        if (trace) {
            log.trace((Object)"getRetryIntervalMultiplier()");
        }
        return this.raProperties.getRetryIntervalMultiplier();
    }

    public void setRetryIntervalMultiplier(Double retryIntervalMultiplier) {
        if (trace) {
            log.trace((Object)("setRetryIntervalMultiplier(" + retryIntervalMultiplier + ")"));
        }
        this.raProperties.setRetryIntervalMultiplier(retryIntervalMultiplier);
    }

    public Integer getReconnectAttempts() {
        if (trace) {
            log.trace((Object)"getReconnectAttempts()");
        }
        return this.raProperties.getReconnectAttempts();
    }

    public void setReconnectAttempts(Integer reconnectAttempts) {
        if (trace) {
            log.trace((Object)("setReconnectAttempts(" + reconnectAttempts + ")"));
        }
        this.raProperties.setReconnectAttempts(reconnectAttempts);
    }

    public Boolean isFailoverOnServerShutdown() {
        if (trace) {
            log.trace((Object)"isFailoverOnServerShutdown()");
        }
        return this.raProperties.isFailoverOnServerShutdown();
    }

    public Boolean getFailoverOnServerShutdown() {
        return this.isFailoverOnServerShutdown();
    }

    public void setFailoverOnServerShutdown(Boolean failoverOnServerShutdown) {
        if (trace) {
            log.trace((Object)("setFailoverOnServerShutdown(" + failoverOnServerShutdown + ")"));
        }
        this.raProperties.setFailoverOnServerShutdown(failoverOnServerShutdown);
    }

    public String getUserName() {
        if (trace) {
            log.trace((Object)"getUserName()");
        }
        return this.raProperties.getUserName();
    }

    public void setUserName(String userName) {
        if (trace) {
            log.trace((Object)("setUserName(" + userName + ")"));
        }
        this.raProperties.setUserName(userName);
    }

    public String getPassword() {
        if (trace) {
            log.trace((Object)"getPassword()");
        }
        return this.raProperties.getPassword();
    }

    public void setPassword(String password) {
        if (trace) {
            log.trace((Object)"setPassword(****)");
        }
        this.raProperties.setPassword(password);
    }

    public String getClientID() {
        if (trace) {
            log.trace((Object)"getClientID()");
        }
        return this.raProperties.getClientID();
    }

    public void setClientID(String clientID) {
        if (trace) {
            log.trace((Object)("setClientID(" + clientID + ")"));
        }
        this.raProperties.setClientID(clientID);
    }

    public Boolean getUseXA() {
        if (trace) {
            log.trace((Object)"getUseXA()");
        }
        return this.raProperties.getUseXA();
    }

    public void setUseXA(Boolean xa) {
        if (trace) {
            log.trace((Object)("setUseXA(" + xa + ")"));
        }
        this.raProperties.setUseXA(xa);
    }

    public boolean equals(Object obj) {
        if (trace) {
            log.trace((Object)("equals(" + obj + ")"));
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof JBMResourceAdapter) {
            return this.raProperties.equals(((JBMResourceAdapter)obj).getProperties());
        }
        return false;
    }

    public int hashCode() {
        if (trace) {
            log.trace((Object)"hashCode()");
        }
        return this.raProperties.hashCode();
    }

    public WorkManager getWorkManager() {
        if (trace) {
            log.trace((Object)"getWorkManager()");
        }
        if (this.ctx == null) {
            return null;
        }
        return this.ctx.getWorkManager();
    }

    public ClientSession createSession(int ackMode, String user, String pass, Boolean preAck, Integer dupsOkBatchSize, Integer transactionBatchSize, boolean deliveryTransacted) throws Exception {
        return this.createSession(this.sessionFactory, ackMode, user, pass, preAck, dupsOkBatchSize, transactionBatchSize, deliveryTransacted);
    }

    public ClientSession createSession(ClientSessionFactory parameterFactory, int ackMode, String user, String pass, Boolean preAck, Integer dupsOkBatchSize, Integer transactionBatchSize, boolean deliveryTransacted) throws Exception {
        ClientSession result;
        boolean actPreAck = preAck != null ? preAck : false;
        int actDupsOkBatchSize = dupsOkBatchSize != null ? dupsOkBatchSize : 0x100000;
        int actTxBatchSize = transactionBatchSize != null ? transactionBatchSize : 0x100000;
        switch (ackMode) {
            case 0: {
                result = parameterFactory.createSession(user, pass, deliveryTransacted, false, false, actPreAck, actTxBatchSize);
                break;
            }
            case 1: {
                result = parameterFactory.createSession(user, pass, deliveryTransacted, true, false, actPreAck, actTxBatchSize);
                break;
            }
            case 3: {
                result = parameterFactory.createSession(user, pass, deliveryTransacted, true, false, actPreAck, actDupsOkBatchSize);
                break;
            }
            case 2: {
                result = parameterFactory.createSession(user, pass, deliveryTransacted, false, false, actPreAck, actTxBatchSize);
                break;
            }
            case 100: {
                result = parameterFactory.createSession(user, pass, deliveryTransacted, false, true, actPreAck, actTxBatchSize);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ackmode: " + ackMode);
            }
        }
        log.debug((Object)("Using queue connection " + result));
        return result;
    }

    private void setParams(JBossConnectionFactory cf) {
        if (this.getLoadBalancingPolicyClassName() != null) {
            cf.setConnectionLoadBalancingPolicyClassName(this.getLoadBalancingPolicyClassName());
        }
        if (this.getClientFailureCheckPeriod() != null) {
            cf.setClientFailureCheckPeriod(this.getClientFailureCheckPeriod().longValue());
        }
        if (this.getConnectionTTL() != null) {
            cf.setConnectionTTL(this.getConnectionTTL().longValue());
        }
        if (this.getCallTimeout() != null) {
            cf.setCallTimeout(this.getCallTimeout().longValue());
        }
        if (this.getClientID() != null) {
            cf.setClientID(this.getClientID());
        }
        if (this.getDupsOKBatchSize() != null) {
            cf.setDupsOKBatchSize(this.getDupsOKBatchSize().intValue());
        }
        if (this.getTransactionBatchSize() != null) {
            cf.setTransactionBatchSize(this.getTransactionBatchSize().intValue());
        }
        if (this.getConsumerWindowSize() != null) {
            cf.setConsumerWindowSize(this.getConsumerWindowSize().intValue());
        }
        if (this.getConsumerMaxRate() != null) {
            cf.setConsumerMaxRate(this.getConsumerMaxRate().intValue());
        }
        if (this.getProducerWindowSize() != null) {
            cf.setProducerWindowSize(this.getProducerWindowSize().intValue());
        }
        if (this.getProducerMaxRate() != null) {
            cf.setProducerMaxRate(this.getProducerMaxRate().intValue());
        }
        if (this.getMinLargeMessageSize() != null) {
            cf.setMinLargeMessageSize(this.getMinLargeMessageSize().intValue());
        }
        if (this.getBlockOnAcknowledge() != null) {
            cf.setBlockOnAcknowledge(this.getBlockOnAcknowledge().booleanValue());
        }
        if (this.getBlockOnNonPersistentSend() != null) {
            cf.setBlockOnNonPersistentSend(this.getBlockOnNonPersistentSend().booleanValue());
        }
        if (this.getBlockOnPersistentSend() != null) {
            cf.setBlockOnPersistentSend(this.getBlockOnPersistentSend().booleanValue());
        }
        if (this.getAutoGroup() != null) {
            cf.setAutoGroup(this.getAutoGroup().booleanValue());
        }
        if (this.getMaxConnections() != null) {
            cf.setMaxConnections(this.getMaxConnections().intValue());
        }
        if (this.getPreAcknowledge() != null) {
            cf.setPreAcknowledge(this.getPreAcknowledge().booleanValue());
        }
        if (this.getRetryInterval() != null) {
            cf.setRetryInterval(this.getRetryInterval().longValue());
        }
        if (this.getRetryIntervalMultiplier() != null) {
            cf.setRetryIntervalMultiplier(this.getRetryIntervalMultiplier().doubleValue());
        }
        if (this.getReconnectAttempts() != null) {
            cf.setReconnectAttempts(this.getReconnectAttempts().intValue());
        }
        if (this.getFailoverOnServerShutdown() != null) {
            cf.setFailoverOnServerShutdown(this.getFailoverOnServerShutdown().booleanValue());
        }
    }

    public JBossConnectionFactory createRemoteFactory(String connectorClassName, Map<String, Object> connectionParameters) {
        TransportConfiguration transportConf = new TransportConfiguration(connectorClassName, connectionParameters);
        TransportConfiguration backup = this.getBackupConnectorClassName() == null ? null : new TransportConfiguration(this.getBackupConnectorClassName(), this.getBackupConnectionParameters());
        JBossConnectionFactory cf = new JBossConnectionFactory(transportConf, backup);
        this.setParams(cf);
        return cf;
    }

    public JBossConnectionFactory createDiscoveryFactory(String discoveryGroup, Integer discoveryGroupPort) {
        JBossConnectionFactory cf = new JBossConnectionFactory(discoveryGroup, discoveryGroupPort.intValue());
        this.setParams(cf);
        return cf;
    }

    protected JBMRAProperties getProperties() {
        if (trace) {
            log.trace((Object)"getProperties()");
        }
        return this.raProperties;
    }

    protected void setup() throws MessagingException {
        if (this.getConnectorClassName() != null) {
            this.jBossConnectionFactory = this.createRemoteFactory(this.getConnectorClassName(), this.getConnectionParameters());
        } else if (this.getDiscoveryGroupAddress() != null && this.getDiscoveryGroupPort() != null) {
            this.jBossConnectionFactory = this.createDiscoveryFactory(this.getDiscoveryGroupAddress(), this.getDiscoveryGroupPort());
        } else {
            log.fatal((Object)"must provide either TransportTyoe or DiscoveryGroupAddress and DiscoveryGroupPort for JBM ResourceAdapter");
        }
        this.sessionFactory = this.jBossConnectionFactory.getCoreFactory();
    }

    public JBossConnectionFactory getJBossConnectionFactory() throws ResourceException {
        if (!this.configured.getAndSet(true)) {
            try {
                this.setup();
            }
            catch (MessagingException e) {
                throw new ResourceException("Unable to create activation", (Throwable)e);
            }
        }
        return this.jBossConnectionFactory;
    }
}

