/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.ra.inflow;

import java.util.HashMap;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.ra.JBMResourceAdapter;
import org.jboss.messaging.ra.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBMActivationSpec
implements ActivationSpec {
    private static final Logger log = Logger.getLogger(JBMActivationSpec.class);
    private static boolean trace = log.isTraceEnabled();
    private Map<String, Object> connectionParameters = new HashMap<String, Object>();
    public String strConnectionParameters;
    private String connectorClassName;
    private JBMResourceAdapter ra;
    private String destination;
    private String destinationType;
    private String messageSelector;
    private int acknowledgeMode;
    private boolean subscriptionDurability;
    private String subscriptionName;
    private String clientId;
    private String user;
    private String password;
    private Integer maxMessages;
    private Integer minSession;
    private Integer maxSession;
    private Long keepAlive;
    private Boolean sessionTransacted;
    private Boolean redeliverUnspecified;
    private Integer transactionTimeout;
    private Boolean isSameRMOverrideValue;
    private boolean useJNDI = true;
    private Boolean forceClearOnShutdown;
    private Long forceClearOnShutdownInterval;
    private Integer forceClearAttempts;

    public JBMActivationSpec() {
        if (trace) {
            log.trace((Object)"constructor()");
        }
        this.ra = null;
        this.destination = null;
        this.destinationType = null;
        this.messageSelector = null;
        this.acknowledgeMode = 0;
        this.subscriptionDurability = false;
        this.subscriptionName = null;
        this.clientId = null;
        this.user = null;
        this.password = null;
        this.maxMessages = 1;
        this.minSession = 1;
        this.maxSession = 15;
        this.keepAlive = 60000L;
        this.sessionTransacted = Boolean.TRUE;
        this.redeliverUnspecified = Boolean.TRUE;
        this.transactionTimeout = 0;
        this.isSameRMOverrideValue = null;
        this.forceClearOnShutdown = Boolean.FALSE;
        this.forceClearOnShutdownInterval = 1000L;
        this.forceClearAttempts = 0;
    }

    public ResourceAdapter getResourceAdapter() {
        if (trace) {
            log.trace((Object)"getResourceAdapter()");
        }
        return this.ra;
    }

    public boolean isUseJNDI() {
        return this.useJNDI;
    }

    public void setUseJNDI(boolean value) {
        this.useJNDI = value;
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        if (trace) {
            log.trace((Object)("setResourceAdapter(" + ra + ")"));
        }
        if (ra == null || !(ra instanceof JBMResourceAdapter)) {
            throw new ResourceException("Resource adapter is " + ra);
        }
        this.ra = (JBMResourceAdapter)ra;
    }

    public String getDestination() {
        if (trace) {
            log.trace((Object)"getDestination()");
        }
        return this.destination;
    }

    public void setDestination(String value) {
        if (trace) {
            log.trace((Object)("setDestination(" + value + ")"));
        }
        this.destination = value;
    }

    public String getDestinationType() {
        if (trace) {
            log.trace((Object)"getDestinationType()");
        }
        return this.destinationType;
    }

    public void setDestinationType(String value) {
        if (trace) {
            log.trace((Object)("setDestinationType(" + value + ")"));
        }
        this.destinationType = value;
    }

    public String getMessageSelector() {
        if (trace) {
            log.trace((Object)"getMessageSelector()");
        }
        return this.messageSelector;
    }

    public void setMessageSelector(String value) {
        if (trace) {
            log.trace((Object)("setMessageSelector(" + value + ")"));
        }
        this.messageSelector = value;
    }

    public String getAcknowledgeMode() {
        if (trace) {
            log.trace((Object)"getAcknowledgeMode()");
        }
        if (this.sessionTransacted.booleanValue()) {
            return "Transacted";
        }
        if (3 == this.acknowledgeMode) {
            return "Dups-ok-acknowledge";
        }
        return "Auto-acknowledge";
    }

    public void setAcknowledgeMode(String value) {
        if (trace) {
            log.trace((Object)("setAcknowledgeMode(" + value + ")"));
        }
        if ("DUPS_OK_ACKNOWLEDGE".equals(value) || "Dups-ok-acknowledge".equals(value)) {
            this.acknowledgeMode = 3;
        } else if ("AUTO_ACKNOWLEDGE".equals(value) || "Auto-acknowledge".equals(value)) {
            this.acknowledgeMode = 1;
        } else if ("SESSION_TRANSACTED".equals(value)) {
            this.acknowledgeMode = 0;
        } else {
            throw new IllegalArgumentException("Unsupported acknowledgement mode " + value);
        }
    }

    public int getAcknowledgeModeInt() {
        if (trace) {
            log.trace((Object)"getAcknowledgeMode()");
        }
        if (this.sessionTransacted.booleanValue()) {
            return 0;
        }
        return this.acknowledgeMode;
    }

    public String getSubscriptionDurability() {
        if (trace) {
            log.trace((Object)"getSubscriptionDurability()");
        }
        if (this.subscriptionDurability) {
            return "Durable";
        }
        return "NonDurable";
    }

    public void setSubscriptionDurability(String value) {
        if (trace) {
            log.trace((Object)("setSubscriptionDurability(" + value + ")"));
        }
        this.subscriptionDurability = "Durable".equals(value);
    }

    public boolean isSubscriptionDurable() {
        if (trace) {
            log.trace((Object)"isSubscriptionDurable()");
        }
        return this.subscriptionDurability;
    }

    public String getSubscriptionName() {
        if (trace) {
            log.trace((Object)"getSubscriptionName()");
        }
        return this.subscriptionName;
    }

    public void setSubscriptionName(String value) {
        if (trace) {
            log.trace((Object)("setSubscriptionName(" + value + ")"));
        }
        this.subscriptionName = value;
    }

    public String getClientId() {
        if (trace) {
            log.trace((Object)"getClientId()");
        }
        if (this.clientId == null) {
            return this.ra.getClientID();
        }
        return this.clientId;
    }

    public void setClientId(String value) {
        if (trace) {
            log.trace((Object)("setClientId(" + value + ")"));
        }
        this.clientId = value;
    }

    public String getUser() {
        if (trace) {
            log.trace((Object)"getUser()");
        }
        if (this.user == null) {
            return this.ra.getUserName();
        }
        return this.user;
    }

    public void setUser(String value) {
        if (trace) {
            log.trace((Object)("setUser(" + value + ")"));
        }
        this.user = value;
    }

    public String getPassword() {
        if (trace) {
            log.trace((Object)"getPassword()");
        }
        if (this.password == null) {
            return this.ra.getPassword();
        }
        return this.password;
    }

    public void setPassword(String value) {
        if (trace) {
            log.trace((Object)("setPassword(" + value + ")"));
        }
        this.password = value;
    }

    public Integer getMaxMessages() {
        if (trace) {
            log.trace((Object)"getMaxMessages()");
        }
        return this.maxMessages;
    }

    public void setMaxMessages(Integer value) {
        if (trace) {
            log.trace((Object)("setMaxMessages(" + value + ")"));
        }
        this.maxMessages = value;
    }

    public int getMaxMessagesInt() {
        if (trace) {
            log.trace((Object)"getMaxMessagesInt()");
        }
        if (this.maxMessages == null) {
            return 0;
        }
        return this.maxMessages;
    }

    public Integer getMinSession() {
        if (trace) {
            log.trace((Object)"getMinSession()");
        }
        return this.minSession;
    }

    public void setMinSession(Integer value) {
        if (trace) {
            log.trace((Object)("setMinSession(" + value + ")"));
        }
        this.minSession = value;
    }

    public int getMinSessionInt() {
        if (trace) {
            log.trace((Object)"getMinSessionInt()");
        }
        if (this.minSession == null) {
            return 0;
        }
        return this.minSession;
    }

    public Integer getMaxSession() {
        if (trace) {
            log.trace((Object)"getMaxSession()");
        }
        return this.maxSession;
    }

    public void setMaxSession(Integer value) {
        if (trace) {
            log.trace((Object)("setMaxSession(" + value + ")"));
        }
        this.maxSession = value;
    }

    public int getMaxSessionInt() {
        if (trace) {
            log.trace((Object)"getMaxSessionInt()");
        }
        if (this.maxSession == null) {
            return 0;
        }
        return this.maxSession;
    }

    public Long getKeepAlive() {
        if (trace) {
            log.trace((Object)"getKeepAlive()");
        }
        return this.keepAlive;
    }

    public void setKeepAlive(Long value) {
        if (trace) {
            log.trace((Object)("setKeepAlive(" + value + ")"));
        }
        this.keepAlive = value;
    }

    public long getKeepAliveLong() {
        if (trace) {
            log.trace((Object)"getKeepAliveLong()");
        }
        if (this.keepAlive == null) {
            return 0L;
        }
        return this.keepAlive;
    }

    public Boolean getSessionTransacted() {
        if (trace) {
            log.trace((Object)"getSessionTransacted()");
        }
        return this.sessionTransacted;
    }

    public void setSessionTransacted(Boolean value) {
        if (trace) {
            log.trace((Object)("setTransactionTimeout(" + value + ")"));
        }
        this.sessionTransacted = value;
    }

    public boolean isSessionTransacted() {
        if (trace) {
            log.trace((Object)"isSessionTransacted()");
        }
        if (this.sessionTransacted == null) {
            return false;
        }
        return this.sessionTransacted;
    }

    public Boolean getRedeliverUnspecified() {
        if (trace) {
            log.trace((Object)"getRedeliverUnspecified()");
        }
        return this.redeliverUnspecified;
    }

    public void setRedeliverUnspecified(Boolean value) {
        if (trace) {
            log.trace((Object)("setRedeliverUnspecified(" + value + ")"));
        }
        this.redeliverUnspecified = value;
    }

    public Integer getTransactionTimeout() {
        if (trace) {
            log.trace((Object)"getTransactionTimeout()");
        }
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(Integer value) {
        if (trace) {
            log.trace((Object)("setTransactionTimeout(" + value + ")"));
        }
        this.transactionTimeout = value;
    }

    public Boolean getIsSameRMOverrideValue() {
        if (trace) {
            log.trace((Object)"getIsSameRMOverrideValue()");
        }
        return this.isSameRMOverrideValue;
    }

    public void setIsSameRMOverrideValue(Boolean value) {
        if (trace) {
            log.trace((Object)("setIsSameRMOverrideValue(" + value + ")"));
        }
        this.isSameRMOverrideValue = value;
    }

    public Boolean getForceClearOnShutdown() {
        if (trace) {
            log.trace((Object)"getForceClearOnShutdown()");
        }
        return this.forceClearOnShutdown;
    }

    public void setForceClearOnShutdown(Boolean value) {
        if (trace) {
            log.trace((Object)("setForceClearOnShutdown(" + value + ")"));
        }
        this.forceClearOnShutdown = value;
    }

    public boolean isForceClearOnShutdown() {
        if (trace) {
            log.trace((Object)"isForceClearOnShutdown()");
        }
        if (this.forceClearOnShutdown == null) {
            return false;
        }
        return this.forceClearOnShutdown;
    }

    public Long getForceClearOnShutdownInterval() {
        if (trace) {
            log.trace((Object)"getForceClearOnShutdownInterval()");
        }
        return this.forceClearOnShutdownInterval;
    }

    public void setForceClearOnShutdownInterval(Long value) {
        if (trace) {
            log.trace((Object)("setForceClearOnShutdownInterval(" + value + ")"));
        }
        this.forceClearOnShutdownInterval = value;
    }

    public Integer getForceClearAttempts() {
        if (trace) {
            log.trace((Object)"getForceClearAttempts()");
        }
        return this.forceClearAttempts;
    }

    public void setForceClearAttempts(Integer value) {
        if (trace) {
            log.trace((Object)("setForceClearAttempts(" + value + ")"));
        }
        this.forceClearAttempts = value;
    }

    public void validate() throws InvalidPropertyException {
        if (trace) {
            log.trace((Object)"validate()");
        }
        if (this.destination == null || this.destination.trim().equals("")) {
            throw new InvalidPropertyException("Destination is mandatory");
        }
    }

    public String getConnectionParameters() {
        return this.strConnectionParameters;
    }

    public Map<String, Object> getParsedConnectionParameters() {
        return this.connectionParameters;
    }

    public void setConnectionParameters(String configuration) {
        this.strConnectionParameters = configuration;
        this.connectionParameters = Util.parseConfig(configuration);
    }

    public String getConnectorClassName() {
        return this.connectorClassName;
    }

    public void setConnectorClassName(String value) {
        this.connectorClassName = value;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(JBMActivationSpec.class.getName()).append('(');
        buffer.append("ra=").append(this.ra);
        buffer.append(" destination=").append(this.destination);
        buffer.append(" destinationType=").append(this.destinationType);
        if (this.messageSelector != null) {
            buffer.append(" selector=").append(this.messageSelector);
        }
        buffer.append(" tx=").append(this.sessionTransacted);
        if (!this.sessionTransacted.booleanValue()) {
            buffer.append(" ack=").append(this.getAcknowledgeMode());
        }
        buffer.append(" durable=").append(this.subscriptionDurability);
        if (this.clientId != null) {
            buffer.append(" clientID=").append(this.clientId);
        }
        if (this.subscriptionName != null) {
            buffer.append(" subscription=").append(this.subscriptionName);
        }
        buffer.append(" user=").append(this.user);
        if (this.password != null) {
            buffer.append(" password=").append("****");
        }
        buffer.append(" maxMessages=").append(this.maxMessages);
        buffer.append(" minSession=").append(this.minSession);
        buffer.append(" maxSession=").append(this.maxSession);
        buffer.append(" keepAlive=").append(this.keepAlive);
        buffer.append(')');
        return buffer.toString();
    }

    public void setUseDLQ(boolean b) {
    }

    public void setDLQJNDIName(String name) {
    }

    public void setDLQMaxResent(int maxResent) {
    }

    public void setProviderAdapterJNDI(String jndi) {
    }
}

