/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.ra.inflow;

import java.util.UUID;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.messaging.core.client.ClientConsumer;
import org.jboss.messaging.core.client.ClientMessage;
import org.jboss.messaging.core.client.ClientSession;
import org.jboss.messaging.core.client.MessageHandler;
import org.jboss.messaging.core.exception.MessagingException;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.core.remoting.impl.wireformat.SessionQueueQueryResponseMessage;
import org.jboss.messaging.jms.JBossTopic;
import org.jboss.messaging.jms.client.JBossMessage;
import org.jboss.messaging.ra.inflow.JBMActivation;
import org.jboss.messaging.ra.inflow.JBMActivationSpec;
import org.jboss.messaging.utils.SimpleString;

public class JBMMessageHandler
implements MessageHandler {
    private static final Logger log = Logger.getLogger(JBMMessageHandler.class);
    private static boolean trace = log.isTraceEnabled();
    private final ClientSession session;
    private MessageEndpoint endpoint;
    private final JBMActivation activation;
    private final DemarcationStrategyFactory strategyFactory = new DemarcationStrategyFactory();

    public JBMMessageHandler(JBMActivation activation, ClientSession session) {
        this.activation = activation;
        this.session = session;
    }

    public void setup() throws Exception {
        ClientConsumer consumer;
        JBMActivationSpec spec;
        String selector;
        SimpleString selectorString;
        if (trace) {
            log.trace((Object)"setup()");
        }
        SimpleString simpleString = selectorString = (selector = (spec = this.activation.getActivationSpec()).getMessageSelector()) == null || selector.trim().equals("") ? null : new SimpleString(selector);
        if (this.activation.isTopic() && spec.isSubscriptionDurable()) {
            String subscriptionName = spec.getSubscriptionName();
            if (this.activation.getActivationSpec().getClientId() == null) {
                throw new InvalidClientIDException("Cannot create durable subscription - client ID has not been set");
            }
            SimpleString queueName = new SimpleString(JBossTopic.createQueueNameForDurableSubscription((String)this.activation.getActivationSpec().getClientId(), (String)subscriptionName));
            SessionQueueQueryResponseMessage subResponse = this.session.queueQuery(queueName);
            if (!subResponse.isExists()) {
                this.session.createQueue(this.activation.getAddress(), queueName, selectorString, true);
            } else {
                boolean topicChanged;
                if (subResponse.getConsumerCount() > 0) {
                    throw new IllegalStateException("Cannot create a subscriber on the durable subscription since it already has subscriber(s)");
                }
                SimpleString oldFilterString = subResponse.getFilterString();
                boolean selectorChanged = selector == null && oldFilterString != null || oldFilterString == null && selector != null || oldFilterString != null && selector != null && !oldFilterString.equals((Object)selector);
                SimpleString oldTopicName = subResponse.getAddress();
                boolean bl = topicChanged = !oldTopicName.equals((Object)this.activation.getAddress());
                if (selectorChanged || topicChanged) {
                    this.session.deleteQueue(queueName);
                    this.session.createQueue(this.activation.getAddress(), queueName, selectorString, true);
                }
            }
            consumer = this.session.createConsumer(queueName, null, false);
        } else {
            SimpleString queueName;
            if (this.activation.isTopic()) {
                queueName = new SimpleString(UUID.randomUUID().toString());
                this.session.createQueue(this.activation.getAddress(), queueName, selectorString, false);
            } else {
                queueName = this.activation.getAddress();
            }
            consumer = this.session.createConsumer(queueName, selectorString);
        }
        MessageEndpointFactory endpointFactory = this.activation.getMessageEndpointFactory();
        this.endpoint = this.activation.isDeliveryTransacted() ? endpointFactory.createEndpoint((XAResource)this.session) : endpointFactory.createEndpoint(null);
        consumer.setMessageHandler((MessageHandler)this);
    }

    public void teardown() {
        if (trace) {
            log.trace((Object)"teardown()");
        }
        try {
            if (this.endpoint != null) {
                this.endpoint.release();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error releasing endpoint " + this.endpoint), t);
        }
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error releasing session " + this.session), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ClientMessage message) {
        if (trace) {
            log.trace((Object)("onMessage(" + message + ")"));
        }
        TransactionDemarcationStrategy txnStrategy = this.strategyFactory.getStrategy();
        try {
            txnStrategy.start();
        }
        catch (Throwable throwable) {
            log.warn((Object)("Unable to create transaction: " + throwable.getMessage()));
            txnStrategy = null;
        }
        JBossMessage jbm = JBossMessage.createMessage((ClientMessage)message, (ClientSession)this.session);
        try {
            jbm.doBeforeReceive();
        }
        catch (Exception e) {
            log.error((Object)"Failed to prepare message for receipt", (Throwable)e);
            return;
        }
        if (this.activation.getActivationSpec().getAcknowledgeModeInt() == 0 || this.activation.getActivationSpec().getAcknowledgeModeInt() == 2) {
            try {
                message.acknowledge();
            }
            catch (MessagingException e) {
                log.error((Object)"Failed to process message", (Throwable)e);
            }
        }
        try {
            this.endpoint.beforeDelivery(JBMActivation.ONMESSAGE);
            try {
                MessageListener listener = (MessageListener)this.endpoint;
                listener.onMessage((Message)jbm);
            }
            finally {
                this.endpoint.afterDelivery();
            }
        }
        catch (Throwable t) {
            log.error((Object)("Unexpected error delivering message " + message), t);
            if (txnStrategy != null) {
                txnStrategy.error();
            }
        }
        finally {
            if (txnStrategy != null) {
                txnStrategy.end();
            }
        }
    }

    private class XATransactionDemarcationStrategy
    implements TransactionDemarcationStrategy {
        private Transaction trans = null;
        private final TransactionManager tm = JBMMessageHandler.access$300(JBMMessageHandler.this).getTransactionManager();

        private XATransactionDemarcationStrategy() {
        }

        public void start() throws Throwable {
            int timeout = JBMMessageHandler.this.activation.getActivationSpec().getTransactionTimeout();
            if (timeout > 0) {
                if (trace) {
                    log.trace((Object)("Setting transactionTimeout for JMSSessionPool to " + timeout));
                }
                this.tm.setTransactionTimeout(timeout);
            }
            this.tm.begin();
            try {
                this.trans = this.tm.getTransaction();
                if (trace) {
                    log.trace((Object)(this + " using tx=" + this.trans));
                }
                if (!this.trans.enlistResource((XAResource)JBMMessageHandler.this.session)) {
                    throw new JMSException("could not enlist resource");
                }
                if (trace) {
                    log.trace((Object)(this + " XAResource '" + JBMMessageHandler.this.session + " enlisted."));
                }
            }
            catch (Throwable t) {
                try {
                    this.tm.rollback();
                }
                catch (Throwable ignored) {
                    log.trace((Object)(this + " ignored error rolling back after failed enlist"), ignored);
                }
                throw t;
            }
        }

        public void error() {
            try {
                if (trace) {
                    log.trace((Object)(this + " using TM to mark TX for rollback tx=" + this.trans));
                }
                this.trans.setRollbackOnly();
            }
            catch (Throwable t) {
                log.error((Object)(this + " failed to set rollback only"), t);
            }
        }

        public void end() {
            try {
                Transaction currentTx = this.tm.getTransaction();
                if (!this.trans.equals(currentTx)) {
                    throw new java.lang.IllegalStateException("Wrong tx association: expected " + this.trans + " was " + currentTx);
                }
                if (this.trans.getStatus() == 1) {
                    if (trace) {
                        log.trace((Object)(this + " rolling back JMS transaction tx=" + this.trans));
                    }
                    this.tm.rollback();
                } else if (this.trans.getStatus() == 0) {
                    if (trace) {
                        log.trace((Object)(this + " commiting the JMS transaction tx=" + this.trans));
                    }
                    this.tm.commit();
                } else {
                    this.tm.suspend();
                }
            }
            catch (Throwable t) {
                log.error((Object)(this + " failed to commit/rollback"), t);
            }
        }
    }

    private class LocalDemarcationStrategy
    implements TransactionDemarcationStrategy {
        private LocalDemarcationStrategy() {
        }

        public void start() {
        }

        public void error() {
            JBMActivationSpec spec;
            if (trace) {
                log.trace((Object)"error()");
            }
            if ((spec = JBMMessageHandler.this.activation.getActivationSpec()).isSessionTransacted() && JBMMessageHandler.this.session != null) {
                try {
                    if (JBMMessageHandler.this.activation.isDeliveryTransacted() || spec.getRedeliverUnspecified().booleanValue()) {
                        JBMMessageHandler.this.session.rollback();
                    }
                }
                catch (MessagingException e) {
                    log.error((Object)"Failed to rollback session transaction", (Throwable)e);
                }
            }
        }

        public void end() {
            JBMActivationSpec spec;
            if (trace) {
                log.trace((Object)"error()");
            }
            if ((spec = JBMMessageHandler.this.activation.getActivationSpec()).isSessionTransacted() && JBMMessageHandler.this.session != null) {
                try {
                    JBMMessageHandler.this.session.commit();
                }
                catch (MessagingException e) {
                    log.error((Object)"Failed to commit session transaction", (Throwable)e);
                }
            }
        }
    }

    private static interface TransactionDemarcationStrategy {
        public void start() throws Throwable;

        public void error();

        public void end();
    }

    private class DemarcationStrategyFactory {
        private DemarcationStrategyFactory() {
        }

        TransactionDemarcationStrategy getStrategy() {
            if (trace) {
                log.trace((Object)"getStrategy()");
            }
            if (JBMMessageHandler.this.activation.isDeliveryTransacted()) {
                try {
                    return new XATransactionDemarcationStrategy();
                }
                catch (Throwable t) {
                    log.error((Object)(this + " error creating transaction demarcation "), t);
                }
            } else {
                return new LocalDemarcationStrategy();
            }
            return null;
        }
    }
}

