/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.ra;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.spi.ConnectionManager;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.ra.JBMConnectionFactory;
import org.jboss.messaging.ra.JBMConnectionManager;
import org.jboss.messaging.ra.JBMManagedConnectionFactory;
import org.jboss.messaging.ra.JBMSessionFactoryImpl;

public class JBMConnectionFactoryImpl
implements JBMConnectionFactory,
Referenceable {
    static final long serialVersionUID = 7981708919479859360L;
    private static final Logger log = Logger.getLogger(JBMConnectionFactoryImpl.class);
    private static boolean trace = log.isTraceEnabled();
    private final JBMManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Reference reference;

    public JBMConnectionFactoryImpl(JBMManagedConnectionFactory mcf, ConnectionManager cm) {
        if (trace) {
            log.trace((Object)("constructor(" + mcf + ", " + cm + ")"));
        }
        this.mcf = mcf;
        if (cm == null) {
            this.cm = new JBMConnectionManager();
            if (trace) {
                log.trace((Object)("Created new ConnectionManager=" + this.cm));
            }
        } else {
            this.cm = cm;
        }
        if (trace) {
            log.trace((Object)("Using ManagedConnectionFactory=" + mcf + ", ConnectionManager=" + cm));
        }
    }

    public void setReference(Reference reference) {
        if (trace) {
            log.trace((Object)("setReference(" + reference + ")"));
        }
        this.reference = reference;
    }

    public Reference getReference() {
        if (trace) {
            log.trace((Object)"getReference()");
        }
        return this.reference;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        if (trace) {
            log.trace((Object)"createQueueConnection()");
        }
        JBMSessionFactoryImpl s = new JBMSessionFactoryImpl(this.mcf, this.cm, 1);
        if (trace) {
            log.trace((Object)("Created queue connection: " + s));
        }
        return s;
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        if (trace) {
            log.trace((Object)("createQueueConnection(" + userName + ", ****)"));
        }
        JBMSessionFactoryImpl s = new JBMSessionFactoryImpl(this.mcf, this.cm, 1);
        s.setUserName(userName);
        s.setPassword(password);
        if (trace) {
            log.trace((Object)("Created queue connection: " + s));
        }
        return s;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        if (trace) {
            log.trace((Object)"createTopicConnection()");
        }
        JBMSessionFactoryImpl s = new JBMSessionFactoryImpl(this.mcf, this.cm, 2);
        if (trace) {
            log.trace((Object)("Created topic connection: " + s));
        }
        return s;
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        if (trace) {
            log.trace((Object)("createTopicConnection(" + userName + ", ****)"));
        }
        JBMSessionFactoryImpl s = new JBMSessionFactoryImpl(this.mcf, this.cm, 2);
        s.setUserName(userName);
        s.setPassword(password);
        if (trace) {
            log.trace((Object)("Created topic connection: " + s));
        }
        return s;
    }

    public Connection createConnection() throws JMSException {
        if (trace) {
            log.trace((Object)"createConnection()");
        }
        JBMSessionFactoryImpl s = new JBMSessionFactoryImpl(this.mcf, this.cm, 0);
        if (trace) {
            log.trace((Object)("Created connection: " + s));
        }
        return s;
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        if (trace) {
            log.trace((Object)("createConnection(" + userName + ", ****)"));
        }
        JBMSessionFactoryImpl s = new JBMSessionFactoryImpl(this.mcf, this.cm, 0);
        s.setUserName(userName);
        s.setPassword(password);
        if (trace) {
            log.trace((Object)("Created connection: " + s));
        }
        return s;
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        if (trace) {
            log.trace((Object)"createXAQueueConnection()");
        }
        JBMSessionFactoryImpl s = new JBMSessionFactoryImpl(this.mcf, this.cm, 4);
        if (trace) {
            log.trace((Object)("Created queue connection: " + s));
        }
        return s;
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        if (trace) {
            log.trace((Object)("createXAQueueConnection(" + userName + ", ****)"));
        }
        JBMSessionFactoryImpl s = new JBMSessionFactoryImpl(this.mcf, this.cm, 4);
        s.setUserName(userName);
        s.setPassword(password);
        if (trace) {
            log.trace((Object)("Created queue connection: " + s));
        }
        return s;
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        if (trace) {
            log.trace((Object)"createXATopicConnection()");
        }
        JBMSessionFactoryImpl s = new JBMSessionFactoryImpl(this.mcf, this.cm, 5);
        if (trace) {
            log.trace((Object)("Created topic connection: " + s));
        }
        return s;
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        if (trace) {
            log.trace((Object)("createXATopicConnection(" + userName + ", ****)"));
        }
        JBMSessionFactoryImpl s = new JBMSessionFactoryImpl(this.mcf, this.cm, 5);
        s.setUserName(userName);
        s.setPassword(password);
        if (trace) {
            log.trace((Object)("Created topic connection: " + s));
        }
        return s;
    }

    public XAConnection createXAConnection() throws JMSException {
        if (trace) {
            log.trace((Object)"createXAConnection()");
        }
        JBMSessionFactoryImpl s = new JBMSessionFactoryImpl(this.mcf, this.cm, 3);
        if (trace) {
            log.trace((Object)("Created connection: " + s));
        }
        return s;
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        if (trace) {
            log.trace((Object)("createXAConnection(" + userName + ", ****)"));
        }
        JBMSessionFactoryImpl s = new JBMSessionFactoryImpl(this.mcf, this.cm, 3);
        s.setUserName(userName);
        s.setPassword(password);
        if (trace) {
            log.trace((Object)("Created connection: " + s));
        }
        return s;
    }
}

