/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.ra;

import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.ra.JBMManagedConnection;

public class JBMLocalTransaction
implements LocalTransaction {
    private static final Logger log = Logger.getLogger(JBMLocalTransaction.class);
    private static boolean trace = log.isTraceEnabled();
    private final JBMManagedConnection mc;

    public JBMLocalTransaction(JBMManagedConnection mc) {
        if (trace) {
            log.trace((Object)("constructor(" + mc + ")"));
        }
        this.mc = mc;
    }

    public void begin() throws ResourceException {
    }

    public void commit() throws ResourceException {
        this.mc.lock();
        try {
            if (this.mc.getSession().getTransacted()) {
                this.mc.getSession().commit();
            }
        }
        catch (JMSException e) {
            throw new ResourceException("Could not commit LocalTransaction", (Throwable)e);
        }
        finally {
            this.mc.unlock();
        }
    }

    public void rollback() throws ResourceException {
        this.mc.lock();
        try {
            if (this.mc.getSession().getTransacted()) {
                this.mc.getSession().rollback();
            }
        }
        catch (JMSException ex) {
            throw new ResourceException("Could not rollback LocalTransaction", (Throwable)ex);
        }
        finally {
            this.mc.unlock();
        }
    }
}

