/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.ra;

import javax.jms.Message;
import javax.jms.MessageListener;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.ra.JBMMessageConsumer;

public class JBMMessageListener
implements MessageListener {
    private static final Logger log = Logger.getLogger(JBMMessageListener.class);
    private static boolean trace = log.isTraceEnabled();
    private final MessageListener listener;
    private final JBMMessageConsumer consumer;

    public JBMMessageListener(MessageListener listener, JBMMessageConsumer consumer) {
        if (trace) {
            log.trace((Object)("constructor(" + listener + ", " + consumer + ")"));
        }
        this.listener = listener;
        this.consumer = consumer;
    }

    public void onMessage(Message message) {
        if (trace) {
            log.trace((Object)("onMessage(" + message + ")"));
        }
        message = this.consumer.wrapMessage(message);
        this.listener.onMessage(message);
    }
}

