/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.ra;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.ra.JBMMessageProducer;
import org.jboss.messaging.ra.JBMSession;

public class JBMTopicPublisher
extends JBMMessageProducer
implements TopicPublisher {
    private static final Logger log = Logger.getLogger(JBMTopicPublisher.class);
    private static boolean trace = log.isTraceEnabled();

    public JBMTopicPublisher(TopicPublisher producer, JBMSession session) {
        super((MessageProducer)producer, session);
        if (trace) {
            log.trace((Object)("constructor(" + producer + ", " + session + ")"));
        }
    }

    public Topic getTopic() throws JMSException {
        if (trace) {
            log.trace((Object)"getTopic()");
        }
        return ((TopicPublisher)this.producer).getTopic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                log.trace((Object)("send " + this + " message=" + message + " deliveryMode=" + deliveryMode + " priority=" + priority + " ttl=" + timeToLive));
            }
            this.checkState();
            ((TopicPublisher)this.producer).publish(message, deliveryMode, priority, timeToLive);
            if (trace) {
                log.trace((Object)("sent " + this + " result=" + message));
            }
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Message message) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                log.trace((Object)("send " + this + " message=" + message));
            }
            this.checkState();
            ((TopicPublisher)this.producer).publish(message);
            if (trace) {
                log.trace((Object)("sent " + this + " result=" + message));
            }
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Topic destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                log.trace((Object)("send " + this + " destination=" + destination + " message=" + message + " deliveryMode=" + deliveryMode + " priority=" + priority + " ttl=" + timeToLive));
            }
            this.checkState();
            ((TopicPublisher)this.producer).publish(destination, message, deliveryMode, priority, timeToLive);
            if (trace) {
                log.trace((Object)("sent " + this + " result=" + message));
            }
        }
        finally {
            this.session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Topic destination, Message message) throws JMSException {
        this.session.lock();
        try {
            if (trace) {
                log.trace((Object)("send " + this + " destination=" + destination + " message=" + message));
            }
            this.checkState();
            ((TopicPublisher)this.producer).publish(destination, message);
            if (trace) {
                log.trace((Object)("sent " + this + " result=" + message));
            }
        }
        finally {
            this.session.unlock();
        }
    }
}

