/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.ra.inflow;

import java.util.UUID;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.messaging.core.client.ClientConsumer;
import org.jboss.messaging.core.client.ClientMessage;
import org.jboss.messaging.core.client.ClientSession;
import org.jboss.messaging.core.client.MessageHandler;
import org.jboss.messaging.core.exception.MessagingException;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.core.remoting.impl.wireformat.SessionQueueQueryResponseMessage;
import org.jboss.messaging.jms.JBossTopic;
import org.jboss.messaging.jms.client.JBossMessage;
import org.jboss.messaging.ra.inflow.JBMActivation;
import org.jboss.messaging.ra.inflow.JBMActivationSpec;
import org.jboss.messaging.utils.SimpleString;

public class JBMMessageHandler
implements MessageHandler {
    private static final Logger log = Logger.getLogger(JBMMessageHandler.class);
    private static boolean trace = log.isTraceEnabled();
    private final ClientSession session;
    private MessageEndpoint endpoint;
    private final JBMActivation activation;
    private final DemarcationStrategyFactory strategyFactory = new DemarcationStrategyFactory();

    public JBMMessageHandler(JBMActivation activation, ClientSession session) {
        this.activation = activation;
        this.session = session;
    }

    public void setup() throws Exception {
        ClientConsumer consumer;
        JBMActivationSpec spec;
        String selector;
        SimpleString selectorString;
        if (trace) {
            log.trace((Object)"setup()");
        }
        SimpleString simpleString = selectorString = (selector = (spec = this.activation.getActivationSpec()).getMessageSelector()) == null || selector.trim().equals("") ? null : new SimpleString(selector);
        if (this.activation.isTopic() && spec.isSubscriptionDurable()) {
            String subscriptionName = spec.getSubscriptionName();
            if (this.activation.getActivationSpec().getClientID() == null) {
                throw new InvalidClientIDException("Cannot create durable subscription - client ID has not been set");
            }
            SimpleString queueName = new SimpleString(JBossTopic.createQueueNameForDurableSubscription((String)this.activation.getActivationSpec().getClientID(), (String)subscriptionName));
            SessionQueueQueryResponseMessage subResponse = this.session.queueQuery(queueName);
            if (!subResponse.isExists()) {
                this.session.createQueue(this.activation.getAddress(), queueName, selectorString, true);
            } else {
                boolean topicChanged;
                if (subResponse.getConsumerCount() > 0) {
                    throw new IllegalStateException("Cannot create a subscriber on the durable subscription since it already has subscriber(s)");
                }
                SimpleString oldFilterString = subResponse.getFilterString();
                boolean selectorChanged = selector == null && oldFilterString != null || oldFilterString == null && selector != null || oldFilterString != null && selector != null && !oldFilterString.equals((Object)selector);
                SimpleString oldTopicName = subResponse.getAddress();
                boolean bl = topicChanged = !oldTopicName.equals((Object)this.activation.getAddress());
                if (selectorChanged || topicChanged) {
                    this.session.deleteQueue(queueName);
                    this.session.createQueue(this.activation.getAddress(), queueName, selectorString, true);
                }
            }
            consumer = this.session.createConsumer(queueName, null, false);
        } else {
            SimpleString queueName;
            if (this.activation.isTopic()) {
                queueName = new SimpleString(UUID.randomUUID().toString());
                this.session.createQueue(this.activation.getAddress(), queueName, selectorString, false);
            } else {
                queueName = this.activation.getAddress();
            }
            consumer = this.session.createConsumer(queueName, selectorString);
        }
        MessageEndpointFactory endpointFactory = this.activation.getMessageEndpointFactory();
        this.endpoint = this.activation.isDeliveryTransacted() && this.activation.getActivationSpec().isUseLocalTx() == false ? endpointFactory.createEndpoint((XAResource)this.session) : endpointFactory.createEndpoint(null);
        consumer.setMessageHandler((MessageHandler)this);
    }

    public void teardown() {
        if (trace) {
            log.trace((Object)"teardown()");
        }
        try {
            if (this.endpoint != null) {
                this.endpoint.release();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error releasing endpoint " + this.endpoint), t);
        }
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (Throwable t) {
            log.debug((Object)("Error releasing session " + this.session), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ClientMessage message) {
        if (trace) {
            log.trace((Object)("onMessage(" + message + ")"));
        }
        TransactionDemarcationStrategy txnStrategy = this.strategyFactory.getStrategy();
        try {
            txnStrategy.start();
        }
        catch (Throwable throwable) {
            log.warn((Object)("Unable to create transaction: " + throwable.getMessage()));
            txnStrategy = new NoTXTransactionDemarcationStrategy();
        }
        JBossMessage jbm = JBossMessage.createMessage((ClientMessage)message, (ClientSession)this.session);
        try {
            jbm.doBeforeReceive();
            message.acknowledge();
        }
        catch (Exception e) {
            log.error((Object)"Failed to prepare message for receipt", (Throwable)e);
            return;
        }
        try {
            ((MessageListener)this.endpoint).onMessage((Message)jbm);
        }
        catch (Throwable t) {
            log.error((Object)("Unexpected error delivering message " + message), t);
            txnStrategy.error();
        }
        finally {
            txnStrategy.end();
        }
    }

    private class NoTXTransactionDemarcationStrategy
    implements TransactionDemarcationStrategy {
        private NoTXTransactionDemarcationStrategy() {
        }

        public void start() throws Throwable {
        }

        public void error() {
        }

        public void end() {
        }
    }

    private class XATransactionDemarcationStrategy
    implements TransactionDemarcationStrategy {
        private final TransactionManager tm;

        private XATransactionDemarcationStrategy() {
            this.tm = JBMMessageHandler.this.activation.getTransactionManager();
        }

        public void start() throws Throwable {
            int timeout = JBMMessageHandler.this.activation.getActivationSpec().getTransactionTimeout();
            if (timeout > 0) {
                if (trace) {
                    log.trace((Object)("Setting transactionTimeout for JMSSessionPool to " + timeout));
                }
                this.tm.setTransactionTimeout(timeout);
            }
            JBMMessageHandler.this.endpoint.beforeDelivery(JBMActivation.ONMESSAGE);
        }

        public void error() {
            try {
                try {
                    this.tm.getTransaction().setRollbackOnly();
                }
                catch (SystemException e) {
                    log.error((Object)"Unable to mark transaction as rollback only", (Throwable)e);
                }
                JBMMessageHandler.this.endpoint.afterDelivery();
            }
            catch (ResourceException e) {
                log.error((Object)"Error calling after delivery on endpoint", (Throwable)e);
            }
        }

        public void end() {
            try {
                JBMMessageHandler.this.endpoint.afterDelivery();
            }
            catch (ResourceException e) {
                log.error((Object)"Error calling after delivery on endpoint", (Throwable)e);
            }
        }
    }

    private class LocalDemarcationStrategy
    implements TransactionDemarcationStrategy {
        private boolean rolledBack = false;

        private LocalDemarcationStrategy() {
        }

        public void start() {
        }

        public void error() {
            if (trace) {
                log.trace((Object)"error()");
            }
            if (JBMMessageHandler.this.session != null) {
                try {
                    JBMMessageHandler.this.session.rollback();
                    this.rolledBack = true;
                }
                catch (MessagingException e) {
                    log.error((Object)"Failed to rollback session transaction", (Throwable)e);
                }
            }
        }

        public void end() {
            if (trace) {
                log.trace((Object)"end()");
            }
            if (!this.rolledBack && JBMMessageHandler.this.session != null) {
                try {
                    JBMMessageHandler.this.session.commit();
                }
                catch (MessagingException e) {
                    log.error((Object)"Failed to commit session transaction", (Throwable)e);
                }
            }
        }
    }

    private static interface TransactionDemarcationStrategy {
        public void start() throws Throwable;

        public void error();

        public void end();
    }

    private class DemarcationStrategyFactory {
        private DemarcationStrategyFactory() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        TransactionDemarcationStrategy getStrategy() {
            if (trace) {
                log.trace((Object)"getStrategy()");
            }
            if (JBMMessageHandler.this.activation.isDeliveryTransacted()) {
                if (JBMMessageHandler.this.activation.getActivationSpec().isUseLocalTx().booleanValue()) return new LocalDemarcationStrategy();
                try {
                    return new XATransactionDemarcationStrategy();
                }
                catch (Throwable t) {
                    log.error((Object)(this + " error creating transaction demarcation "), t);
                    return null;
                }
            } else {
                if (JBMMessageHandler.this.activation.getActivationSpec().isUseLocalTx().booleanValue()) return new LocalDemarcationStrategy();
                return new NoTXTransactionDemarcationStrategy();
            }
        }
    }
}

