/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.integration.transports.netty;

import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.jboss.messaging.core.exception.MessagingException;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.core.remoting.impl.ssl.SSLSupport;
import org.jboss.messaging.core.remoting.spi.BufferHandler;
import org.jboss.messaging.core.remoting.spi.Connection;
import org.jboss.messaging.core.remoting.spi.ConnectionLifeCycleListener;
import org.jboss.messaging.core.remoting.spi.Connector;
import org.jboss.messaging.integration.transports.netty.ChannelPipelineSupport;
import org.jboss.messaging.integration.transports.netty.MessagingChannelHandler;
import org.jboss.messaging.integration.transports.netty.NettyConnection;
import org.jboss.messaging.integration.transports.netty.VirtualExecutorService;
import org.jboss.messaging.utils.ConfigurationHelper;
import org.jboss.messaging.utils.Future;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.UpstreamMessageEvent;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.http.HttpTunnelAddress;
import org.jboss.netty.channel.socket.http.HttpTunnelingClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.ssl.SslHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyConnector
implements Connector {
    private static final Logger log = Logger.getLogger(NettyConnector.class);
    private ClientSocketChannelFactory channelFactory;
    private ClientBootstrap bootstrap;
    private ChannelGroup channelGroup;
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    private final boolean sslEnabled;
    private final boolean httpEnabled;
    private final long httpMaxClientIdleTime;
    private final long httpClientIdleScanPeriod;
    private final boolean httpRequiresSessionId;
    private final boolean useNio;
    private final boolean useServlet;
    private final String host;
    private final int port;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final boolean tcpNoDelay;
    private final int tcpSendBufferSize;
    private final int tcpReceiveBufferSize;
    private ConcurrentMap<Object, Connection> connections = new ConcurrentHashMap<Object, Connection>();
    private final String servletPath;
    private final VirtualExecutorService virtualExecutor;

    public NettyConnector(Map<String, Object> configuration, BufferHandler handler, ConnectionLifeCycleListener listener, Executor threadPool) {
        if (listener == null) {
            throw new IllegalArgumentException("Invalid argument null listener");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Invalid argument null handler");
        }
        this.listener = listener;
        this.handler = handler;
        this.sslEnabled = ConfigurationHelper.getBooleanProperty((String)"jbm.remoting.netty.sslenabled", (boolean)false, configuration);
        this.httpEnabled = ConfigurationHelper.getBooleanProperty((String)"jbm.remoting.netty.httpenabled", (boolean)false, configuration);
        this.servletPath = ConfigurationHelper.getStringProperty((String)"jbm.remoting.netty.servletpath", (String)"/messaging/JBMServlet", configuration);
        if (this.httpEnabled) {
            this.httpMaxClientIdleTime = ConfigurationHelper.getLongProperty((String)"jbm.remoting.netty.httpclientidletime", (long)500L, configuration);
            this.httpClientIdleScanPeriod = ConfigurationHelper.getLongProperty((String)"jbm.remoting.netty.httpclientidlescanperiod", (long)500L, configuration);
            this.httpRequiresSessionId = ConfigurationHelper.getBooleanProperty((String)"jbm.remoting.netty.httprequiressessionid", (boolean)false, configuration);
        } else {
            this.httpMaxClientIdleTime = 0L;
            this.httpClientIdleScanPeriod = -1L;
            this.httpRequiresSessionId = false;
        }
        this.useNio = ConfigurationHelper.getBooleanProperty((String)"jbm.remoting.netty.usenio", (boolean)true, configuration);
        this.useServlet = ConfigurationHelper.getBooleanProperty((String)"jbm.remoting.netty.useservlet", (boolean)false, configuration);
        this.host = ConfigurationHelper.getStringProperty((String)"jbm.remoting.netty.host", (String)"localhost", configuration);
        this.port = ConfigurationHelper.getIntProperty((String)"jbm.remoting.netty.port", (int)5445, configuration);
        if (this.sslEnabled) {
            this.keyStorePath = ConfigurationHelper.getStringProperty((String)"jbm.remoting.netty.keystorepath", (String)"messaging.keystore", configuration);
            this.keyStorePassword = ConfigurationHelper.getStringProperty((String)"jbm.remoting.netty.keystorepassword", (String)"secureexample", configuration);
        } else {
            this.keyStorePath = null;
            this.keyStorePassword = null;
        }
        this.tcpNoDelay = ConfigurationHelper.getBooleanProperty((String)"jbm.remoting.netty.tcpnodelay", (boolean)true, configuration);
        this.tcpSendBufferSize = ConfigurationHelper.getIntProperty((String)"jbm.remoting.netty.tcpsendbuffersize", (int)32768, configuration);
        this.tcpReceiveBufferSize = ConfigurationHelper.getIntProperty((String)"jbm.remoting.netty.tcpreceivebuffersize", (int)32768, configuration);
        this.virtualExecutor = new VirtualExecutorService(threadPool);
    }

    public synchronized void start() {
        SSLContext context;
        if (this.channelFactory != null) {
            return;
        }
        this.channelFactory = this.useNio ? new NioClientSocketChannelFactory((Executor)this.virtualExecutor, (Executor)this.virtualExecutor) : new OioClientSocketChannelFactory((Executor)this.virtualExecutor);
        if (this.useServlet) {
            ClientSocketChannelFactory proxyChannelFactory = this.channelFactory;
            this.channelFactory = new HttpTunnelingClientSocketChannelFactory(proxyChannelFactory, (Executor)this.virtualExecutor);
        }
        this.bootstrap = new ClientBootstrap((ChannelFactory)this.channelFactory);
        this.bootstrap.setOption("tcpNoDelay", (Object)this.tcpNoDelay);
        if (this.tcpReceiveBufferSize != -1) {
            this.bootstrap.setOption("receiveBufferSize", (Object)this.tcpReceiveBufferSize);
        }
        if (this.tcpSendBufferSize != -1) {
            this.bootstrap.setOption("sendBufferSize", (Object)this.tcpSendBufferSize);
        }
        this.bootstrap.setOption("keepAlive", (Object)true);
        this.bootstrap.setOption("reuseAddress", (Object)true);
        this.channelGroup = new DefaultChannelGroup("jbm-connector");
        if (this.sslEnabled) {
            try {
                context = SSLSupport.getInstance((boolean)true, (String)this.keyStorePath, (String)this.keyStorePassword, null, null);
            }
            catch (Exception e) {
                this.close();
                IllegalStateException ise = new IllegalStateException("Unable to create NettyConnector for " + this.host);
                ise.initCause(e);
                throw ise;
            }
        } else {
            context = null;
        }
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                if (NettyConnector.this.sslEnabled) {
                    ChannelPipelineSupport.addSSLFilter(pipeline, context, true);
                }
                if (NettyConnector.this.httpEnabled) {
                    pipeline.addLast("httpRequestEncoder", (ChannelHandler)new HttpRequestEncoder());
                    pipeline.addLast("httpResponseDecoder", (ChannelHandler)new HttpResponseDecoder());
                    pipeline.addLast("httphandler", (ChannelHandler)new HttpHandler());
                }
                ChannelPipelineSupport.addCodecFilter(pipeline, NettyConnector.this.handler);
                pipeline.addLast("handler", (ChannelHandler)new MessagingClientChannelHandler(NettyConnector.this.channelGroup, NettyConnector.this.handler, new Listener()));
                return pipeline;
            }
        });
    }

    public synchronized void close() {
        if (this.channelFactory == null) {
            return;
        }
        this.bootstrap = null;
        this.channelGroup.close().awaitUninterruptibly();
        this.channelFactory.releaseExternalResources();
        this.channelFactory = null;
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.connections.clear();
    }

    public boolean isStarted() {
        return this.channelFactory != null;
    }

    public Connection createConnection() {
        InetSocketAddress address;
        if (this.channelFactory == null) {
            return null;
        }
        if (this.useServlet) {
            try {
                URI uri = new URI("http", null, this.host, this.port, this.servletPath, null, null);
                address = new HttpTunnelAddress(uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else {
            address = new InetSocketAddress(this.host, this.port);
        }
        ChannelFuture future = this.bootstrap.connect((SocketAddress)address);
        future.awaitUninterruptibly();
        if (future.isSuccess()) {
            Channel ch = future.getChannel();
            SslHandler sslHandler = (SslHandler)ch.getPipeline().get(SslHandler.class);
            if (sslHandler != null) {
                try {
                    ChannelFuture handshakeFuture = sslHandler.handshake(ch);
                    handshakeFuture.awaitUninterruptibly();
                    if (!handshakeFuture.isSuccess()) {
                        ch.close().awaitUninterruptibly();
                        return null;
                    }
                    ((MessagingChannelHandler)ch.getPipeline().get(MessagingChannelHandler.class)).active = true;
                }
                catch (SSLException e) {
                    ch.close();
                    return null;
                }
            } else {
                ((MessagingChannelHandler)ch.getPipeline().get(MessagingChannelHandler.class)).active = true;
            }
            NettyConnection conn = new NettyConnection(ch, new Listener());
            return conn;
        }
        Throwable t = future.getCause();
        if (t != null && !(t instanceof ConnectException)) {
            log.error((Object)"Failed to create netty connection", future.getCause());
        }
        return null;
    }

    static /* synthetic */ String access$500(NettyConnector x0) {
        return x0.host;
    }

    static /* synthetic */ int access$600(NettyConnector x0) {
        return x0.port;
    }

    static /* synthetic */ String access$700(NettyConnector x0) {
        return x0.servletPath;
    }

    private class Listener
    implements ConnectionLifeCycleListener {
        private Listener() {
        }

        public void connectionCreated(Connection connection) {
            if (NettyConnector.this.connections.putIfAbsent(connection.getID(), connection) != null) {
                throw new IllegalArgumentException("Connection already exists with id " + connection.getID());
            }
        }

        public void connectionDestroyed(final Object connectionID) {
            if (NettyConnector.this.connections.remove(connectionID) != null) {
                new Thread(){

                    public void run() {
                        NettyConnector.this.listener.connectionDestroyed(connectionID);
                    }
                }.start();
            }
        }

        public void connectionException(final Object connectionID, final MessagingException me) {
            new Thread(){

                public void run() {
                    NettyConnector.this.listener.connectionException(connectionID, me);
                }
            }.start();
        }
    }

    @ChannelPipelineCoverage(value="one")
    class HttpHandler
    extends SimpleChannelHandler {
        private Channel channel;
        private long lastSendTime = 0L;
        private boolean waitingGet = false;
        private Timer idleClientTimer;
        private HttpIdleTimerTask task;
        private String url = "http://" + NettyConnector.access$500(NettyConnector.this) + ":" + NettyConnector.access$600(NettyConnector.this) + NettyConnector.access$700(NettyConnector.this);
        private Future handShakeFuture = new Future();
        private boolean active = false;
        private boolean handshaking = false;
        private CookieDecoder cookieDecoder = new CookieDecoder();
        private String cookie;
        private CookieEncoder cookieEncoder = new CookieEncoder(false);

        HttpHandler() {
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            super.channelConnected(ctx, e);
            this.channel = e.getChannel();
            if (NettyConnector.this.httpClientIdleScanPeriod > 0L) {
                this.idleClientTimer = new Timer("Http Idle Timer", true);
                this.task = new HttpIdleTimerTask();
                this.idleClientTimer.schedule((TimerTask)this.task, NettyConnector.this.httpClientIdleScanPeriod, NettyConnector.this.httpClientIdleScanPeriod);
            }
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            if (this.idleClientTimer != null) {
                this.task.cancel();
                this.idleClientTimer.cancel();
            }
            super.channelClosed(ctx, e);
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            HttpResponse response = (HttpResponse)e.getMessage();
            if (NettyConnector.this.httpRequiresSessionId && !this.active) {
                Set cookieMap = this.cookieDecoder.decode(response.getHeader("Set-Cookie"));
                for (Cookie cookie : cookieMap) {
                    if (!cookie.getName().equals("JSESSIONID")) continue;
                    this.cookieEncoder.addCookie(cookie);
                    this.cookie = this.cookieEncoder.encode();
                }
                this.active = true;
                this.handShakeFuture.run();
            }
            UpstreamMessageEvent event = new UpstreamMessageEvent(e.getChannel(), (Object)response.getContent(), e.getRemoteAddress());
            this.waitingGet = false;
            ctx.sendUpstream((ChannelEvent)event);
        }

        public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            if (e.getMessage() instanceof ChannelBuffer) {
                if (NettyConnector.this.httpRequiresSessionId && !this.active) {
                    if (this.handshaking) {
                        this.handshaking = true;
                    } else if (!this.handShakeFuture.await(5000L)) {
                        throw new RuntimeException("Handshake failed after timeout");
                    }
                }
                DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.url);
                if (this.cookie != null) {
                    httpRequest.addHeader("Cookie", this.cookie);
                }
                ChannelBuffer buf = (ChannelBuffer)e.getMessage();
                httpRequest.setContent(buf);
                httpRequest.addHeader("Content-Length", String.valueOf(buf.writerIndex()));
                Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)httpRequest, (SocketAddress)e.getRemoteAddress());
                this.lastSendTime = System.currentTimeMillis();
            } else {
                Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)e.getMessage(), (SocketAddress)e.getRemoteAddress());
                this.lastSendTime = System.currentTimeMillis();
            }
        }

        private class HttpIdleTimerTask
        extends TimerTask {
            long currentTime = System.currentTimeMillis();

            private HttpIdleTimerTask() {
            }

            public synchronized void run() {
                if (!HttpHandler.this.waitingGet && System.currentTimeMillis() > HttpHandler.this.lastSendTime + NettyConnector.this.httpMaxClientIdleTime) {
                    DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, HttpHandler.this.url);
                    HttpHandler.this.waitingGet = true;
                    HttpHandler.this.channel.write((Object)httpRequest);
                }
            }

            public synchronized boolean cancel() {
                return super.cancel();
            }
        }
    }

    @ChannelPipelineCoverage(value="one")
    private final class MessagingClientChannelHandler
    extends MessagingChannelHandler {
        MessagingClientChannelHandler(ChannelGroup group, BufferHandler handler, ConnectionLifeCycleListener listener) {
            super(group, handler, listener);
        }
    }
}

