/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.integration.transports.netty;

import org.jboss.messaging.core.remoting.spi.MessagingBuffer;
import org.jboss.messaging.utils.SimpleString;
import org.jboss.messaging.utils.UTF8Util;
import org.jboss.netty.buffer.ChannelBuffer;

public class ChannelBufferWrapper
implements MessagingBuffer {
    private final ChannelBuffer buffer;

    public ChannelBufferWrapper(ChannelBuffer buffer) {
        this.buffer = buffer;
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public void clear() {
        this.buffer.clear();
    }

    public boolean readable() {
        return this.buffer.readable();
    }

    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    public byte readByte() {
        return this.buffer.readByte();
    }

    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.buffer.readBytes(dst, dstIndex, length);
    }

    public void readBytes(byte[] dst) {
        this.buffer.readBytes(dst);
    }

    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    public void readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
    }

    public int readInt() {
        return this.buffer.readInt();
    }

    public long readLong() {
        return this.buffer.readLong();
    }

    public short readShort() {
        return this.buffer.readShort();
    }

    public short readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    public int readUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    public void resetReaderIndex() {
        this.buffer.resetReaderIndex();
    }

    public void resetWriterIndex() {
        this.buffer.resetWriterIndex();
    }

    public void setIndex(int readerIndex, int writerIndex) {
        this.buffer.setIndex(readerIndex, writerIndex);
    }

    public void setInt(int index, int value) {
        this.buffer.setInt(index, value);
    }

    public boolean writable() {
        return this.buffer.writable();
    }

    public int writableBytes() {
        return this.buffer.writableBytes();
    }

    public void writeByte(byte value) {
        this.buffer.writeByte(value);
    }

    public void writeBytes(byte[] src, int srcIndex, int length) {
        this.buffer.writeBytes(src, srcIndex, length);
    }

    public void writeBytes(MessagingBuffer src, int srcIndex, int length) {
        byte[] bytes = new byte[length];
        src.readBytes(bytes, srcIndex, length);
        this.writeBytes(bytes);
    }

    public void writeBytes(byte[] src) {
        this.buffer.writeBytes(src);
    }

    public void writeInt(int value) {
        this.buffer.writeInt(value);
    }

    public void writeLong(long value) {
        this.buffer.writeLong(value);
    }

    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    public void writerIndex(int writerIndex) {
        this.buffer.writerIndex(writerIndex);
    }

    public void writeShort(short value) {
        this.buffer.writeShort(value);
    }

    public byte[] array() {
        return this.buffer.toByteBuffer().array();
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public char readChar() {
        return (char)this.readShort();
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public SimpleString readNullableSimpleString() {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readSimpleString();
    }

    public String readNullableString() {
        byte b = this.readByte();
        if (b == 0) {
            return null;
        }
        return this.readString();
    }

    public SimpleString readSimpleString() {
        int len = this.readInt();
        byte[] data = new byte[len];
        this.readBytes(data);
        return new SimpleString(data);
    }

    public String readString() {
        int len = this.readInt();
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = this.readChar();
        }
        return new String(chars);
    }

    public String readUTF() throws Exception {
        return UTF8Util.readUTF((MessagingBuffer)this);
    }

    public void writeBoolean(boolean val) {
        this.writeByte((byte)(val ? -1 : 0));
    }

    public void writeChar(char val) {
        this.writeShort((short)val);
    }

    public void writeDouble(double val) {
        this.writeLong(Double.doubleToLongBits(val));
    }

    public void writeFloat(float val) {
        this.writeInt(Float.floatToIntBits(val));
    }

    public void writeNullableSimpleString(SimpleString val) {
        if (val == null) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)1);
            this.writeSimpleString(val);
        }
    }

    public void writeNullableString(String val) {
        if (val == null) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)1);
            this.writeString(val);
        }
    }

    public void writeSimpleString(SimpleString val) {
        byte[] data = val.getData();
        this.writeInt(data.length);
        this.writeBytes(data);
    }

    public void writeString(String val) {
        this.writeInt(val.length());
        for (int i = 0; i < val.length(); ++i) {
            this.writeShort((short)val.charAt(i));
        }
    }

    public void writeUTF(String utf) throws Exception {
        UTF8Util.saveUTF((MessagingBuffer)this, (String)utf);
    }

    public Object getUnderlyingBuffer() {
        return this.buffer;
    }
}

