/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.integration.transports.netty;

import org.jboss.messaging.core.exception.MessagingException;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.core.remoting.spi.BufferHandler;
import org.jboss.messaging.core.remoting.spi.ConnectionLifeCycleListener;
import org.jboss.messaging.core.remoting.spi.MessagingBuffer;
import org.jboss.messaging.integration.transports.netty.ChannelBufferWrapper;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;

class MessagingChannelHandler
extends SimpleChannelHandler {
    private static final Logger log = Logger.getLogger(MessagingChannelHandler.class);
    private final ChannelGroup group;
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    volatile boolean active;

    MessagingChannelHandler(ChannelGroup group, BufferHandler handler, ConnectionLifeCycleListener listener) {
        this.group = group;
        this.handler = handler;
        this.listener = listener;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.group.add((Object)e.getChannel());
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        ChannelBuffer buffer = (ChannelBuffer)e.getMessage();
        this.handler.bufferReceived((Object)e.getChannel().getId(), (MessagingBuffer)new ChannelBufferWrapper(buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        MessagingChannelHandler messagingChannelHandler = this;
        synchronized (messagingChannelHandler) {
            if (this.active) {
                this.listener.connectionDestroyed((Object)e.getChannel().getId());
                this.active = false;
            }
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        MessagingChannelHandler messagingChannelHandler = this;
        synchronized (messagingChannelHandler) {
            if (!this.active) {
                return;
            }
            MessagingException me = new MessagingException(0, "Netty exception");
            me.initCause(e.getCause());
            try {
                this.listener.connectionException((Object)e.getChannel().getId(), me);
                this.active = false;
            }
            catch (Exception ex) {
                log.error((Object)"failed to notify the listener:", (Throwable)ex);
            }
        }
    }
}

