/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.integration.transports.netty;

import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.core.remoting.spi.BufferHandler;
import org.jboss.messaging.core.remoting.spi.MessagingBuffer;
import org.jboss.messaging.integration.transports.netty.ChannelBufferWrapper;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class MessagingFrameDecoder
extends FrameDecoder {
    private static final Logger log = Logger.getLogger(MessagingFrameDecoder.class);
    private final BufferHandler handler;

    public MessagingFrameDecoder(BufferHandler handler) {
        this.handler = handler;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer in) throws Exception {
        int start = in.readerIndex();
        int length = this.handler.isReadyToHandle((MessagingBuffer)new ChannelBufferWrapper(in));
        if (length == -1) {
            in.readerIndex(start);
            return null;
        }
        in.readerIndex(start + 4);
        return in.readBytes(length);
    }
}

