/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.integration.transports.netty;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.jboss.messaging.core.config.TransportConfiguration;
import org.jboss.messaging.core.exception.MessagingException;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.core.remoting.impl.ssl.SSLSupport;
import org.jboss.messaging.core.remoting.spi.Acceptor;
import org.jboss.messaging.core.remoting.spi.BufferHandler;
import org.jboss.messaging.core.remoting.spi.Connection;
import org.jboss.messaging.core.remoting.spi.ConnectionLifeCycleListener;
import org.jboss.messaging.integration.transports.netty.ChannelPipelineSupport;
import org.jboss.messaging.integration.transports.netty.HttpAcceptorHandler;
import org.jboss.messaging.integration.transports.netty.HttpKeepAliveRunnable;
import org.jboss.messaging.integration.transports.netty.MessagingChannelHandler;
import org.jboss.messaging.integration.transports.netty.NettyConnection;
import org.jboss.messaging.integration.transports.netty.VirtualExecutorService;
import org.jboss.messaging.utils.ConfigurationHelper;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.local.DefaultLocalServerChannelFactory;
import org.jboss.netty.channel.local.LocalAddress;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.ssl.SslHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NettyAcceptor
implements Acceptor {
    private static final Logger log = Logger.getLogger(NettyAcceptor.class);
    private ChannelFactory channelFactory;
    private volatile ChannelGroup serverChannelGroup;
    private volatile ChannelGroup channelGroup;
    private ServerBootstrap bootstrap;
    private final BufferHandler handler;
    private final ConnectionLifeCycleListener listener;
    private final boolean sslEnabled;
    private final boolean httpEnabled;
    private final long httpServerScanPeriod;
    private final long httpResponseTime;
    private final boolean useNio;
    private final boolean useInvm;
    private final String host;
    private final int port;
    private final String keyStorePath;
    private final String keyStorePassword;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final boolean tcpNoDelay;
    private final int tcpSendBufferSize;
    private final int tcpReceiveBufferSize;
    private final HttpKeepAliveRunnable httpKeepAliveRunnable;
    private ConcurrentMap<Object, Connection> connections = new ConcurrentHashMap<Object, Connection>();
    private boolean paused;
    private final Executor threadPool;

    public NettyAcceptor(Map<String, Object> configuration, BufferHandler handler, ConnectionLifeCycleListener listener, Executor threadPool, ScheduledExecutorService scheduledThreadPool) {
        this.handler = handler;
        this.listener = listener;
        this.sslEnabled = ConfigurationHelper.getBooleanProperty((String)"jbm.remoting.netty.sslenabled", (boolean)false, configuration);
        this.httpEnabled = ConfigurationHelper.getBooleanProperty((String)"jbm.remoting.netty.httpenabled", (boolean)false, configuration);
        if (this.httpEnabled) {
            this.httpServerScanPeriod = ConfigurationHelper.getLongProperty((String)"jbm.remoting.netty.httpserverscanperiod", (long)5000L, configuration);
            this.httpResponseTime = ConfigurationHelper.getLongProperty((String)"jbm.remoting.netty.httpresponsetime", (long)10000L, configuration);
            this.httpKeepAliveRunnable = new HttpKeepAliveRunnable();
            ScheduledFuture<?> future = scheduledThreadPool.scheduleAtFixedRate(this.httpKeepAliveRunnable, this.httpServerScanPeriod, this.httpServerScanPeriod, TimeUnit.MILLISECONDS);
            this.httpKeepAliveRunnable.setFuture(future);
        } else {
            this.httpServerScanPeriod = 0L;
            this.httpResponseTime = 0L;
            this.httpKeepAliveRunnable = null;
        }
        this.useNio = ConfigurationHelper.getBooleanProperty((String)"jbm.remoting.netty.usenio", (boolean)true, configuration);
        this.useInvm = ConfigurationHelper.getBooleanProperty((String)"jbm.remoting.netty.useinvm", (boolean)false, configuration);
        this.host = ConfigurationHelper.getStringProperty((String)"jbm.remoting.netty.host", (String)"localhost", configuration);
        this.port = ConfigurationHelper.getIntProperty((String)"jbm.remoting.netty.port", (int)5445, configuration);
        if (this.sslEnabled) {
            this.keyStorePath = ConfigurationHelper.getStringProperty((String)"jbm.remoting.netty.keystorepath", (String)"messaging.keystore", configuration);
            this.keyStorePassword = ConfigurationHelper.getStringProperty((String)"jbm.remoting.netty.keystorepassword", (String)"secureexample", configuration);
            this.trustStorePath = ConfigurationHelper.getStringProperty((String)"jbm.remoting.netty.truststorepath", (String)"messaging.truststore", configuration);
            this.trustStorePassword = ConfigurationHelper.getStringProperty((String)"jbm.remoting.netty.truststorepassword", (String)"secureexample", configuration);
        } else {
            this.keyStorePath = null;
            this.keyStorePassword = null;
            this.trustStorePath = null;
            this.trustStorePassword = null;
        }
        this.tcpNoDelay = ConfigurationHelper.getBooleanProperty((String)"jbm.remoting.netty.tcpnodelay", (boolean)true, configuration);
        this.tcpSendBufferSize = ConfigurationHelper.getIntProperty((String)"jbm.remoting.netty.tcpsendbuffersize", (int)32768, configuration);
        this.tcpReceiveBufferSize = ConfigurationHelper.getIntProperty((String)"jbm.remoting.netty.tcpreceivebuffersize", (int)32768, configuration);
        this.threadPool = threadPool;
    }

    public synchronized void start() throws Exception {
        SSLContext context;
        if (this.channelFactory != null) {
            return;
        }
        VirtualExecutorService virtualExecutor = new VirtualExecutorService(this.threadPool);
        this.channelFactory = this.useInvm ? new DefaultLocalServerChannelFactory() : (this.useNio ? new NioServerSocketChannelFactory((Executor)virtualExecutor, (Executor)virtualExecutor) : new OioServerSocketChannelFactory((Executor)virtualExecutor, (Executor)virtualExecutor));
        this.bootstrap = new ServerBootstrap(this.channelFactory);
        if (this.sslEnabled) {
            try {
                context = SSLSupport.createServerContext((String)this.keyStorePath, (String)this.keyStorePassword, (String)this.trustStorePath, (String)this.trustStorePassword);
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException("Unable to create NettyAcceptor for " + this.host + ":" + this.port);
                ise.initCause(e);
                throw ise;
            }
        } else {
            context = null;
        }
        ChannelPipelineFactory factory = new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                if (NettyAcceptor.this.sslEnabled) {
                    ChannelPipelineSupport.addSSLFilter(pipeline, context, false);
                }
                if (NettyAcceptor.this.httpEnabled) {
                    pipeline.addLast("httpRequestDecoder", (ChannelHandler)new HttpRequestDecoder());
                    pipeline.addLast("httpResponseEncoder", (ChannelHandler)new HttpResponseEncoder());
                    pipeline.addLast("httphandler", (ChannelHandler)new HttpAcceptorHandler(NettyAcceptor.this.httpKeepAliveRunnable, NettyAcceptor.this.httpResponseTime));
                }
                ChannelPipelineSupport.addCodecFilter(pipeline, NettyAcceptor.this.handler);
                pipeline.addLast("handler", (ChannelHandler)new MessagingServerChannelHandler(NettyAcceptor.this.channelGroup, NettyAcceptor.this.handler, new Listener()));
                return pipeline;
            }
        };
        this.bootstrap.setPipelineFactory(factory);
        this.bootstrap.setOption("child.tcpNoDelay", (Object)this.tcpNoDelay);
        if (this.tcpReceiveBufferSize != -1) {
            this.bootstrap.setOption("child.receiveBufferSize", (Object)this.tcpReceiveBufferSize);
        }
        if (this.tcpSendBufferSize != -1) {
            this.bootstrap.setOption("child.sendBufferSize", (Object)this.tcpSendBufferSize);
        }
        this.bootstrap.setOption("reuseAddress", (Object)true);
        this.bootstrap.setOption("child.reuseAddress", (Object)true);
        this.bootstrap.setOption("child.keepAlive", (Object)true);
        this.channelGroup = new DefaultChannelGroup("jbm-accepted-channels");
        this.serverChannelGroup = new DefaultChannelGroup("jbm-acceptor-channels");
        this.startServerChannels();
        this.paused = false;
    }

    private void startServerChannels() {
        String[] hosts;
        for (String h : hosts = TransportConfiguration.splitHosts((String)this.host)) {
            Object address = this.useInvm ? new LocalAddress(h) : new InetSocketAddress(h, this.port);
            Channel serverChannel = this.bootstrap.bind((SocketAddress)address);
            this.serverChannelGroup.add((Object)serverChannel);
        }
    }

    public synchronized void pause() {
        if (this.paused) {
            return;
        }
        if (this.channelFactory == null) {
            return;
        }
        this.serverChannelGroup.close().awaitUninterruptibly();
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.paused = true;
    }

    public synchronized void resume() {
        if (!this.paused) {
            return;
        }
        this.startServerChannels();
        this.paused = false;
    }

    public synchronized void stop() {
        ChannelGroupFuture future;
        if (this.channelFactory == null) {
            return;
        }
        if (!this.paused) {
            this.serverChannelGroup.close().awaitUninterruptibly();
        }
        if (this.httpKeepAliveRunnable != null) {
            this.httpKeepAliveRunnable.close();
        }
        if (!(future = this.channelGroup.close().awaitUninterruptibly()).isCompleteSuccess()) {
            log.warn((Object)"channel group did not completely close");
            for (Channel channel : future.getGroup()) {
                if (!channel.isBound()) continue;
                log.warn((Object)(channel + " is still connected to " + channel.getRemoteAddress()));
            }
        }
        this.channelFactory.releaseExternalResources();
        this.channelFactory = null;
        for (Connection connection : this.connections.values()) {
            this.listener.connectionDestroyed(connection.getID());
        }
        this.connections.clear();
    }

    public boolean isStarted() {
        return this.channelFactory != null;
    }

    private class Listener
    implements ConnectionLifeCycleListener {
        private Listener() {
        }

        public void connectionCreated(Connection connection) {
            if (NettyAcceptor.this.connections.putIfAbsent(connection.getID(), connection) != null) {
                throw new IllegalArgumentException("Connection already exists with id " + connection.getID());
            }
            NettyAcceptor.this.listener.connectionCreated(connection);
        }

        public void connectionDestroyed(Object connectionID) {
            if (NettyAcceptor.this.connections.remove(connectionID) != null) {
                NettyAcceptor.this.listener.connectionDestroyed(connectionID);
            }
        }

        public void connectionException(final Object connectionID, final MessagingException me) {
            new Thread(){

                public void run() {
                    NettyAcceptor.this.listener.connectionException(connectionID, me);
                }
            }.start();
        }
    }

    @ChannelPipelineCoverage(value="one")
    private final class MessagingServerChannelHandler
    extends MessagingChannelHandler {
        MessagingServerChannelHandler(ChannelGroup group, BufferHandler handler, ConnectionLifeCycleListener listener) {
            super(group, handler, listener);
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            new NettyConnection(e.getChannel(), new Listener());
            SslHandler sslHandler = (SslHandler)ctx.getPipeline().get(SslHandler.class);
            if (sslHandler != null) {
                sslHandler.handshake(e.getChannel()).addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            MessagingServerChannelHandler.this.active = true;
                        } else {
                            future.getChannel().close();
                        }
                    }
                });
            } else {
                this.active = true;
            }
        }
    }
}

