/*
 * Copyright The JBoss Metadata Authors
 * SPDX-License-Identifier: Apache-2.0
 */
package org.jboss.metadata.javaee.spec;

/**
 * Constants.
 *
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @author Eduardo Martins
 * @version $Revision: 8.0 $
 */
public interface JavaEEMetaDataConstants {
    /**
     * The jakartaee namespace
     */
    String JAKARTAEE_NS = "https://jakarta.ee/xml/ns/jakartaee";
    /**
     * The javaee namespace
     */
    String JAVAEE_NS = "http://java.sun.com/xml/ns/javaee";
    String JAVAEE_7_NS = "http://xmlns.jcp.org/xml/ns/javaee";
    /**
     * The j2ee namespace
     */
    String J2EE_NS = "http://java.sun.com/xml/ns/j2ee";

    /**
     * The j2ee 1.3 public Ids
     */
    String J2EE_13_APP = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN";
    String J2EE_13_CLIENT = "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN";
    String J2EE_13_EJB = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    String J2EE_13_WEB = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    String J2EE_13_TLD = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN";

    /**
     * The jboss javaee namespaces
     */
    String JBOSS_NS = "http://www.jboss.com/xml/ns/javaee";
    /**
     * The jboss jakartaee namespaces
     */
    String JBOSS_JAKARTAEE_NS = "urn:jboss:jakartaee:1.0";

    /**
     * The jbosscmp-jdbc namespace
     */
    String JBOSS_CMP2X_NS = "http://www.jboss.com/xml/ns/javaee/cmp2x";

    String XSD_NS = "http://www.w3.org/2001/XMLSchema";
}
