/*
 * Copyright The JBoss Metadata Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package org.jboss.metadata.parser.ee;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;

/**
 * @author Remy Maucherat
 */
public class MessageDestinationMetaDataParser extends MetaDataElementParser {

    public static MessageDestinationMetaData parse(XMLStreamReader reader, final PropertyReplacer propertyReplacer) throws XMLStreamException {
        MessageDestinationMetaData messageDestination = new MessageDestinationMetaData();

        IdMetaDataParser.parseAttributes(reader, messageDestination);

        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        // Handle elements
        while (reader.hasNext() && reader.nextTag() != END_ELEMENT) {
            if (DescriptionGroupMetaDataParser.parse(reader, descriptionGroup)) {
                if (messageDestination.getDescriptionGroup() == null) {
                    messageDestination.setDescriptionGroup(descriptionGroup);
                }
                continue;
            }
            final Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case MESSAGE_DESTINATION_NAME:
                    messageDestination.setMessageDestinationName(getElementText(reader, propertyReplacer));
                    break;
                case JNDI_NAME:
                    messageDestination.setJndiName(getElementText(reader, propertyReplacer));
                    break;
                case MAPPED_NAME:
                    messageDestination.setMappedName(getElementText(reader, propertyReplacer));
                    break;
                case LOOKUP_NAME:
                    messageDestination.setLookupName(getElementText(reader, propertyReplacer));
                    break;
                default:
                    throw unexpectedElement(reader);
            }
        }

        return messageDestination;
    }

}
