/*
 * Copyright The JBoss Metadata Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package org.jboss.metadata.parser.ee;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

import org.jboss.metadata.javaee.spec.DescriptionsImpl;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.PropertyReplacers;

/**
 * @author Remy Maucherat
 */
public class ParamValueMetaDataParser extends MetaDataElementParser {

    public static ParamValueMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        return parse(reader, PropertyReplacers.noop());
    }

    public static ParamValueMetaData parse(XMLStreamReader reader, final PropertyReplacer propertyReplacer) throws XMLStreamException {
        ParamValueMetaData paramValue = new ParamValueMetaData();

        IdMetaDataParser.parseAttributes(reader, paramValue);

        DescriptionsImpl descriptions = new DescriptionsImpl();
        // Handle elements
        while (reader.hasNext() && reader.nextTag() != END_ELEMENT) {
            if (DescriptionsMetaDataParser.parse(reader, descriptions, propertyReplacer)) {
                if (paramValue.getDescriptions() == null) {
                    paramValue.setDescriptions(descriptions);
                }
                continue;
            }
            final Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PARAM_NAME:
                    paramValue.setParamName(getElementText(reader, propertyReplacer));
                    break;
                case PARAM_VALUE:
                    paramValue.setParamValue(getElementText(reader, propertyReplacer));
                    break;
                default:
                    throw unexpectedElement(reader);
            }
        }

        boolean validParamName = paramValue.validateParamName();
        boolean validParamValue = paramValue.validateParamValue();

        if (!validParamName) {
            throw new XMLStreamException("param-name element missing in context-param",reader.getLocation());
        }

        if (!validParamValue) {
            throw new XMLStreamException("param-value element missing in context-param",reader.getLocation());
        }

        return paramValue;
    }

}
