/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ws;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jws.HandlerChain;
import org.jboss.logging.Logger;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.creator.ws.ServiceReferenceHandlerChainsWrapper;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerChainsMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceHandlerMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.HandlerChainsObjectFactory;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;

public class WebServiceHandlerChainProcessor<E extends AnnotatedElement>
extends AbstractFinderUser
implements Processor<ServiceReferenceMetaData, E> {
    private static Logger log = Logger.getLogger(WebServiceHandlerChainProcessor.class);
    private static final DefaultSchemaResolver resolver = new DefaultSchemaResolver();

    public WebServiceHandlerChainProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    @Override
    public void process(ServiceReferenceMetaData refs, E type) {
        HandlerChain annotation = this.finder.getAnnotation(type, HandlerChain.class);
        if (annotation == null) {
            return;
        }
        if (annotation.file() != null && annotation.file().length() > 1) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("processing HandlerChain for element: " + type));
            }
            this.process(refs, type, annotation);
        }
    }

    protected void process(ServiceReferenceMetaData refs, E element, HandlerChain annotation) {
        String fileName = annotation.file();
        ServiceReferenceHandlerChainsMetaData handlerChains = null;
        try {
            InputStream in = this.getResourceInputStream(element, fileName);
            handlerChains = this.unmarshall(in);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not process file: " + fileName, e);
        }
        if (handlerChains == null) {
            return;
        }
        if (refs.getHandlerChains() != null) {
            ServiceReferenceHandlerChainsMetaData merged = new ServiceReferenceHandlerChainsMetaData();
            merged.merge(handlerChains, refs.getHandlerChains());
            refs.setHandlerChains(merged);
        } else {
            refs.setHandlerChains(handlerChains);
        }
    }

    protected ServiceReferenceHandlerChainsMetaData unmarshall(InputStream in) throws JBossXBException {
        if (in == null) {
            throw new IllegalArgumentException("InputStream may not be null.");
        }
        Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        UnifiedHandlerChainsMetaData handlerChainsUMDM = (UnifiedHandlerChainsMetaData)unmarshaller.unmarshal(in, (ObjectModelFactory)new HandlerChainsObjectFactory(), null);
        return this.transform(handlerChainsUMDM);
    }

    private ServiceReferenceHandlerChainsMetaData transform(UnifiedHandlerChainsMetaData handlerChainsUMDM) {
        if (handlerChainsUMDM == null) {
            return null;
        }
        LinkedList<ServiceReferenceHandlerChainMetaData> handlerChains = new LinkedList<ServiceReferenceHandlerChainMetaData>();
        for (UnifiedHandlerChainMetaData handlerChainUMDM : handlerChainsUMDM.getHandlerChains()) {
            ServiceReferenceHandlerChainMetaData newChainMD = this.transform(handlerChainUMDM);
            if (newChainMD == null) continue;
            handlerChains.add(newChainMD);
        }
        if (handlerChains.size() == 0) {
            return null;
        }
        ServiceReferenceHandlerChainsMetaData retVal = new ServiceReferenceHandlerChainsMetaData();
        retVal.setHandlers(handlerChains);
        return retVal;
    }

    private ServiceReferenceHandlerChainMetaData transform(UnifiedHandlerChainMetaData handlerChainUMDM) {
        if (handlerChainUMDM == null || handlerChainUMDM.isExcluded()) {
            return null;
        }
        LinkedList<ServiceReferenceHandlerMetaData> handlers = new LinkedList<ServiceReferenceHandlerMetaData>();
        for (UnifiedHandlerMetaData handlerUMDM : handlerChainUMDM.getHandlers()) {
            ServiceReferenceHandlerMetaData newHandlerMD = this.transform(handlerUMDM);
            if (newHandlerMD == null) continue;
            handlers.add(newHandlerMD);
        }
        if (handlers.size() == 0) {
            return null;
        }
        ServiceReferenceHandlerChainMetaData retVal = new ServiceReferenceHandlerChainMetaData();
        retVal.setPortNamePattern(handlerChainUMDM.getPortNamePattern());
        retVal.setProtocolBindings(handlerChainUMDM.getProtocolBindings());
        retVal.setServiceNamePattern(handlerChainUMDM.getServiceNamePattern());
        retVal.setHandler(handlers);
        return retVal;
    }

    private ServiceReferenceHandlerMetaData transform(UnifiedHandlerMetaData handlerUMDM) {
        if (handlerUMDM == null) {
            return null;
        }
        ServiceReferenceHandlerMetaData retVal = new ServiceReferenceHandlerMetaData();
        retVal.setHandlerClass(handlerUMDM.getHandlerClass());
        retVal.setHandlerName(handlerUMDM.getHandlerName());
        retVal.setPortName(this.toList(handlerUMDM.getPortNames()));
        retVal.setSoapHeader(this.toList(handlerUMDM.getSoapHeaders()));
        retVal.setSoapRole(this.toList(handlerUMDM.getSoapRoles()));
        retVal.setInitParam(this.transform(handlerUMDM.getInitParams()));
        return retVal;
    }

    private List<ParamValueMetaData> transform(List<UnifiedInitParamMetaData> initParams) {
        if (initParams == null || initParams.size() == 0) {
            return null;
        }
        LinkedList<ParamValueMetaData> retVal = new LinkedList<ParamValueMetaData>();
        for (UnifiedInitParamMetaData initParamUMDM : initParams) {
            ParamValueMetaData paramValueMD = new ParamValueMetaData();
            paramValueMD.setParamName(initParamUMDM.getParamName());
            paramValueMD.setParamValue(initParamUMDM.getParamValue());
            retVal.add(paramValueMD);
        }
        return retVal;
    }

    private List toList(Set set) {
        if (set == null) {
            return null;
        }
        LinkedList retVal = new LinkedList();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            retVal.add(i.next());
        }
        return retVal;
    }

    protected InputStream getResourceInputStream(E type, String file) throws MalformedURLException, IOException, IllegalStateException {
        URL url;
        if (file.startsWith("http://") && (url = new URL(file)) != null) {
            return url.openStream();
        }
        String fileName = file;
        Class<?> declaredClass = this.resolveDeclaringClass(type);
        InputStream in = declaredClass.getResourceAsStream(fileName);
        if (in != null) {
            return in;
        }
        if (!file.startsWith("/")) {
            String baseName = declaredClass.getName();
            int index = baseName.lastIndexOf(46);
            if (index != -1) {
                fileName = baseName.substring(0, index).replace('.', '/') + "/" + file;
            }
        } else {
            fileName = file.substring(1);
        }
        in = declaredClass.getResourceAsStream(fileName);
        if (in != null) {
            return in;
        }
        throw new IllegalStateException("could not find file: " + file);
    }

    private Class<?> resolveDeclaringClass(E element) {
        if (element == null) {
            throw new IllegalArgumentException("element may not be null.");
        }
        if (element instanceof Class) {
            return (Class)element;
        }
        if (element instanceof Method) {
            return ((Method)element).getDeclaringClass();
        }
        return ((Field)element).getDeclaringClass();
    }

    @Override
    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(HandlerChain.class);
    }

    static {
        resolver.addClassBinding("http://java.sun.com/xml/ns/javaee", ServiceReferenceHandlerChainsWrapper.class);
    }
}

