/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.jboss;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    CONTEXT_ROOT("context-root"),
    HAR("har"),
    JMX_NAME("jmx-name"),
    LIBRARY_DIRECTORY("library-directory"),
    LOADER_REPOSITORY("loader-repository"),
    LOADER_REPOSITORY_CONFIG("loader-repository-config"),
    MODULE("module"),
    MODULE_ORDER("module-order"),
    PRINCIPAL_NAME("principal-name"),
    ROLE_NAME("role-name"),
    SECURITY_DOMAIN("security-domain"),
    SECURITY_ROLE("security-role"),
    SERVICE("service"),
    UNAUTHENTICATED_PRINCIPAL("unauthenticated-principal"),
    WEB("web"),
    WEB_URI("web-uri");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

