/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.spec;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ear.spec.Ear13DTDMetaData;
import org.jboss.metadata.ear.spec.Ear14MetaData;
import org.jboss.metadata.ear.spec.Ear50MetaData;
import org.jboss.metadata.ear.spec.Ear5xMetaData;
import org.jboss.metadata.ear.spec.Ear60MetaData;
import org.jboss.metadata.ear.spec.Ear6xMetaData;
import org.jboss.metadata.ear.spec.EarEnvironmentRefsGroupMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.ear.spec.ModulesMetaData;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.metadata.parser.ee.EnvironmentRefsGroupMetaDataParser;
import org.jboss.metadata.parser.ee.MessageDestinationMetaDataParser;
import org.jboss.metadata.parser.ee.SecurityRoleMetaDataParser;
import org.jboss.metadata.parser.spec.Attribute;
import org.jboss.metadata.parser.spec.EarModuleMetaDataParser;
import org.jboss.metadata.parser.spec.Element;
import org.jboss.metadata.parser.spec.Version;
import org.jboss.metadata.parser.util.MetaDataElementParser;

public class EarMetaDataParser
extends MetaDataElementParser {
    public static EarMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        int i;
        int count;
        reader.require(7, null, null);
        Version version = null;
        while (reader.hasNext() && reader.next() != 1) {
            String dtdLocation;
            if (reader.getEventType() != 11 || (dtdLocation = EarMetaDataParser.readDTDLocation((XMLStreamReader)reader)) == null) continue;
            version = Version.forLocation(dtdLocation);
        }
        String schemaLocation = EarMetaDataParser.readSchemaLocation((XMLStreamReader)reader);
        if (schemaLocation != null) {
            version = Version.forLocation(schemaLocation);
        }
        if (version == null || Version.UNKNOWN.equals((Object)version)) {
            String versionString = null;
            count = reader.getAttributeCount();
            for (i = 0; i < count; ++i) {
                Attribute attribute;
                if (reader.getAttributeNamespace(i) != null || (attribute = Attribute.forName(reader.getAttributeLocalName(i))) != Attribute.VERSION) continue;
                versionString = reader.getAttributeValue(i);
            }
            if ("1.4".equals(versionString)) {
                version = Version.APP_1_4;
            } else if ("5".equals(versionString)) {
                version = Version.APP_5_0;
            } else if ("6".equals(versionString)) {
                version = Version.APP_6_0;
            }
        }
        if (version == null || Version.UNKNOWN.equals((Object)version)) {
            version = Version.APP_6_0;
        }
        EarMetaData earMetaData = null;
        switch (version) {
            case APP_1_3: {
                earMetaData = new Ear13DTDMetaData();
                break;
            }
            case APP_1_4: {
                earMetaData = new Ear14MetaData();
                break;
            }
            case APP_5_0: {
                earMetaData = new Ear50MetaData();
                break;
            }
            case APP_6_0: {
                earMetaData = new Ear60MetaData();
            }
        }
        earMetaData.setVersion(version.getVersion());
        count = reader.getAttributeCount();
        block20: for (i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (reader.getAttributeNamespace(i) != null) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    earMetaData.setId(value);
                    continue block20;
                }
                case VERSION: {
                    earMetaData.setVersion(value);
                    continue block20;
                }
                default: {
                    throw EarMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        SecurityRolesMetaData securityRolesMetaData = new SecurityRolesMetaData();
        EarEnvironmentRefsGroupMetaData environmentRefsGroupMetaData = new EarEnvironmentRefsGroupMetaData();
        MessageDestinationsMetaData messageDestinationsMetaData = new MessageDestinationsMetaData();
        ModulesMetaData modulesMetaData = new ModulesMetaData();
        block21: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionGroupMetaDataParser.parse((XMLStreamReader)reader, (DescriptionGroupMetaData)descriptionGroup) || EnvironmentRefsGroupMetaDataParser.parse((XMLStreamReader)reader, (EnvironmentRefsGroupMetaData)environmentRefsGroupMetaData)) continue;
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case APPLICATION_NAME: {
                    if (earMetaData instanceof Ear6xMetaData) {
                        ((Ear6xMetaData)((Object)Ear6xMetaData.class.cast((Object)earMetaData))).setApplicationName(EarMetaDataParser.getElementText((XMLStreamReader)reader));
                        continue block21;
                    }
                    throw EarMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
                case INITIALIZATION_IN_ORDER: {
                    if (earMetaData instanceof Ear6xMetaData) {
                        ((Ear6xMetaData)((Object)Ear6xMetaData.class.cast((Object)earMetaData))).setInitializeInOrder(Boolean.parseBoolean(EarMetaDataParser.getElementText((XMLStreamReader)reader)));
                        continue block21;
                    }
                    throw EarMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
                case LIBRARY_DIRECTORY: {
                    if (earMetaData instanceof Ear5xMetaData) {
                        ((Ear5xMetaData)((Object)Ear5xMetaData.class.cast((Object)earMetaData))).setLibraryDirectory(EarMetaDataParser.getElementText((XMLStreamReader)reader));
                        continue block21;
                    }
                    throw EarMetaDataParser.unexpectedElement((XMLStreamReader)reader);
                }
                case MESSAGE_DESTINATION: {
                    messageDestinationsMetaData.add((MappableMetaData)MessageDestinationMetaDataParser.parse((XMLStreamReader)reader));
                    continue block21;
                }
                case MODULE: {
                    modulesMetaData.add((MappableMetaData)EarModuleMetaDataParser.parse(reader));
                    continue block21;
                }
                case SECURITY_ROLE: {
                    securityRolesMetaData.add((MappableMetaData)SecurityRoleMetaDataParser.parse((XMLStreamReader)reader));
                    continue block21;
                }
            }
            throw EarMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        earMetaData.setDescriptionGroup(descriptionGroup);
        earMetaData.setModules(modulesMetaData);
        earMetaData.setSecurityRoles(securityRolesMetaData);
        environmentRefsGroupMetaData.setMessageDestinations(messageDestinationsMetaData);
        if (earMetaData instanceof Ear6xMetaData) {
            ((Ear6xMetaData)((Object)Ear6xMetaData.class.cast((Object)earMetaData))).setEarEnvironmentRefsGroup(environmentRefsGroupMetaData);
        }
        return earMetaData;
    }
}

