/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.jboss;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.jboss.annotation.javaee.Descriptions;
import org.jboss.metadata.ejb.jboss.ContainerConfigurationMetaData;
import org.jboss.metadata.ejb.jboss.ContainerConfigurationMetaDataWrapper;
import org.jboss.metadata.ejb.jboss.ContainerConfigurationsMetaData;

public class ContainerConfigurationsMetaDataWrapper
extends ContainerConfigurationsMetaData {
    private static final long serialVersionUID = 1L;
    private ContainerConfigurationsMetaData primary;
    private ContainerConfigurationsMetaData defaults;
    private HashMap<String, ContainerConfigurationMetaData> merged = new HashMap();

    ContainerConfigurationsMetaDataWrapper(ContainerConfigurationsMetaData primary, ContainerConfigurationsMetaData defaults) {
        String extendsName;
        ContainerConfigurationMetaData parent;
        ContainerConfigurationMetaData md;
        this.primary = primary;
        this.defaults = defaults;
        if (defaults == null) {
            throw new IllegalStateException("defaults cannot be null");
        }
        for (String key : defaults.keySet()) {
            md = (ContainerConfigurationMetaData)defaults.get(key);
            parent = null;
            extendsName = md.getExtendsName();
            if (extendsName != null) {
                parent = this.merged.get(extendsName);
                if (parent == null) {
                    parent = (ContainerConfigurationMetaData)defaults.get(extendsName);
                }
                if (parent == null) {
                    throw new IllegalStateException("Failed to find parent configuration: " + extendsName + " among: " + String.valueOf(defaults.keySet()));
                }
            }
            md = new ContainerConfigurationMetaDataWrapper(md, parent);
            this.merged.put(key, md);
        }
        if (primary != null) {
            for (String key : primary.keySet()) {
                md = (ContainerConfigurationMetaData)primary.get(key);
                parent = null;
                extendsName = md.getExtendsName();
                if (extendsName != null) {
                    parent = (ContainerConfigurationMetaData)primary.get(extendsName);
                    if (parent == null) {
                        parent = this.merged.get(extendsName);
                    }
                    if (parent == null) {
                        parent = (ContainerConfigurationMetaData)defaults.get(extendsName);
                    }
                    if (parent == null) {
                        throw new IllegalStateException("Failed to find parent configuration: " + extendsName + " among defaults: " + String.valueOf(defaults.keySet()) + " config: " + String.valueOf(primary.keySet()));
                    }
                } else {
                    parent = this.merged.get(key);
                    if (parent == null) {
                        parent = (ContainerConfigurationMetaData)defaults.get(key);
                    }
                }
                md = new ContainerConfigurationMetaDataWrapper(md, parent);
                this.merged.put(key, md);
            }
        }
    }

    public boolean containsKey(String key) {
        return this.merged.containsKey(key);
    }

    public ContainerConfigurationMetaData get(String key) {
        ContainerConfigurationMetaData ccmd = this.merged.get(key);
        return ccmd;
    }

    public Descriptions getDescriptions() {
        Descriptions descriptions = null;
        if (this.primary != null) {
            descriptions = this.primary.getDescriptions();
        }
        if (descriptions == null) {
            descriptions = this.defaults.getDescriptions();
        }
        return descriptions;
    }

    public String getId() {
        String id;
        String string = id = this.primary != null ? this.primary.getId() : null;
        if (id == null) {
            id = this.defaults.getId();
        }
        return id;
    }

    public boolean isEmpty() {
        boolean isEmpty = this.merged.isEmpty();
        return isEmpty;
    }

    public Iterator<ContainerConfigurationMetaData> iterator() {
        return this.merged.values().iterator();
    }

    public Set<String> keySet() {
        return this.merged.keySet();
    }

    public int size() {
        return this.merged.size();
    }

    public Object[] toArray() {
        return this.merged.values().toArray();
    }

    public <X> X[] toArray(X[] a) {
        return this.merged.values().toArray(a);
    }

    public String toString() {
        return this.merged.toString();
    }
}

