/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb.jboss;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.interceptor.AroundInvoke;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokeMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;

public class AroundInvokeProcessor
extends AbstractFinderUser
implements Creator<Method, AroundInvokeMetaData>,
Processor<JBossSessionBeanMetaData, Method> {
    public AroundInvokeProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public AroundInvokeMetaData create(Method method) {
        AroundInvoke init = (AroundInvoke)this.finder.getAnnotation((AnnotatedElement)method, AroundInvoke.class);
        if (init == null) {
            return null;
        }
        AroundInvokeMetaData metaData = new AroundInvokeMetaData();
        String className = method.getDeclaringClass().getName();
        metaData.setClassName(className);
        metaData.setMethodName(method.getName());
        return metaData;
    }

    public void process(JBossSessionBeanMetaData bean, Method method) {
        AroundInvokeMetaData metaData = this.create(method);
        if (metaData == null) {
            return;
        }
        AroundInvokesMetaData invokes = bean.getAroundInvokes();
        if (invokes == null) {
            invokes = new AroundInvokesMetaData();
            bean.setAroundInvokes(invokes);
        }
        invokes.add(metaData);
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(AroundInvoke.class);
    }
}

