/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.jboss.jndi.resolver.impl;

import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEntityBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndi.resolver.impl.AbstractJNDIPolicyBasedJNDINameResolver;
import org.jboss.metadata.ejb.jboss.jndi.resolver.spi.EntityBeanJNDINameResolver;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.KnownInterfaces;

public class JNDIPolicyBasedEntityBeanJNDINameResolver
extends AbstractJNDIPolicyBasedJNDINameResolver
implements EntityBeanJNDINameResolver {
    private static Logger logger = Logger.getLogger(JNDIPolicyBasedEntityBeanJNDINameResolver.class);

    public JNDIPolicyBasedEntityBeanJNDINameResolver() {
    }

    public JNDIPolicyBasedEntityBeanJNDINameResolver(DefaultJndiBindingPolicy jndiBindingPolicy) {
        super(jndiBindingPolicy);
    }

    @Override
    public String resolveLocalHomeJNDIName(JBossEntityBeanMetaData metadata) {
        if (metadata.getLocalJndiName() != null) {
            return metadata.getLocalJndiName();
        }
        DefaultJndiBindingPolicy policy = this.getJNDIBindingPolicy(metadata);
        return policy.getJndiName(this.getEjbDeploymentSummary(metadata), metadata.getLocalHome(), KnownInterfaces.KnownInterfaceType.LOCAL_HOME);
    }

    @Override
    public String resolveRemoteHomeJNDIName(JBossEntityBeanMetaData metadata) {
        if (metadata.getJndiName() != null) {
            return metadata.getJndiName();
        }
        DefaultJndiBindingPolicy policy = this.getJNDIBindingPolicy(metadata);
        return policy.getJndiName(this.getEjbDeploymentSummary(metadata), metadata.getHome(), KnownInterfaces.KnownInterfaceType.REMOTE_HOME);
    }

    @Override
    public String resolveJNDIName(JBossEntityBeanMetaData metadata, String interfaceName) {
        String resolvedJndiName = null;
        KnownInterfaces.KnownInterfaceType ifaceType = this.classifyInterface(metadata, interfaceName);
        if (ifaceType.equals((Object)KnownInterfaces.KnownInterfaceType.REMOTE_HOME)) {
            resolvedJndiName = this.resolveRemoteHomeJNDIName(metadata);
        } else if (ifaceType.equals((Object)KnownInterfaces.KnownInterfaceType.LOCAL_HOME)) {
            resolvedJndiName = this.resolveLocalHomeJNDIName(metadata);
        } else {
            DefaultJndiBindingPolicy policy = this.getJNDIBindingPolicy(metadata);
            resolvedJndiName = policy.getJndiName(this.getEjbDeploymentSummary(metadata), interfaceName, ifaceType);
        }
        logger.debug((Object)("Resolved JNDI Name for Interface " + interfaceName + " of type " + (Object)((Object)ifaceType) + " is " + resolvedJndiName));
        return resolvedJndiName;
    }

    protected KnownInterfaces.KnownInterfaceType classifyInterface(JBossEntityBeanMetaData metadata, String interfaceName) {
        KnownInterfaces.KnownInterfaceType ifaceType = KnownInterfaces.classifyInterface(interfaceName);
        if (ifaceType != KnownInterfaces.KnownInterfaceType.UNKNOWN) {
            return ifaceType;
        }
        if (metadata.getLocalHome() != null && metadata.getLocalHome().equals(interfaceName)) {
            return KnownInterfaces.KnownInterfaceType.LOCAL_HOME;
        }
        if (metadata.getHome() != null && metadata.getHome().equals(interfaceName)) {
            return KnownInterfaces.KnownInterfaceType.REMOTE_HOME;
        }
        return KnownInterfaces.KnownInterfaceType.UNKNOWN;
    }
}

