/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metadata.annotation.creator;

import java.lang.reflect.Method;

import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision: 80110 $
 */
public class EjbProcessorUtils
{
   public static MethodMetaData createMethod(String ejbName, Method method)
   {
      MethodMetaData methodMetaData = new MethodMetaData();
      methodMetaData.setEjbName(ejbName);
      if(method == null)
         methodMetaData.setMethodName("*");
      else
      {
         methodMetaData.setMethodName(method.getName());
         MethodParametersMetaData methodParameters = getMethodParameters(method);
         if(methodParameters != null)
            methodMetaData.setMethodParams(methodParameters);
      }
      return methodMetaData;
   }

   public static MethodParametersMetaData getMethodParameters(Method method)
   {
      MethodParametersMetaData metaData = new MethodParametersMetaData();
      for(Class<?> parameterType : method.getParameterTypes())
      {
         metaData.add(parameterType.getName());
      }
      return metaData;
   }

}
