/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import javax.ejb.EJBObject;
import javax.ejb.Remote;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.ejb.spec.SessionBeanMetaData;
import org.jboss.metadata.lang.ClassHelper;

public class RemoteProcessor
extends AbstractFinderUser
implements Processor<SessionBeanMetaData, Class<?>> {
    public RemoteProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    protected void addBusinessInterface(SessionBeanMetaData metaData, Class<?> businessInterface) {
        if (EJBObject.class.isAssignableFrom(businessInterface)) {
            throw new IllegalStateException("EJB 3.0 Core Specification Violation (4.6.6): The session bean\u2019s business interface " + businessInterface + " must not extend the javax.ejb.EJBObject interface.");
        }
        if (metaData.getBusinessRemotes() == null) {
            metaData.setBusinessRemotes(new BusinessRemotesMetaData());
        }
        metaData.getBusinessRemotes().add(businessInterface.getName());
    }

    public void process(SessionBeanMetaData metaData, Class<?> type) {
        Remote remote = (Remote)this.finder.getAnnotation(type, Remote.class);
        if (remote == null) {
            return;
        }
        if (type.isInterface()) {
            this.addBusinessInterface(metaData, type);
        } else if (remote.value() == null || remote.value().length == 0) {
            Class businessInterface = ClassHelper.getDefaultInterface(type);
            this.addBusinessInterface(metaData, businessInterface);
        } else {
            for (Class businessInterface : remote.value()) {
                this.addBusinessInterface(metaData, businessInterface);
            }
        }
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(Remote.class);
    }
}

