/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.metadata.annotation.creator.rar;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;

import org.jboss.logging.Logger;
import org.jboss.metadata.annotation.creator.AbstractCreator;
import org.jboss.metadata.annotation.creator.Creator;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.rar.spec.ConnectorMetaData;
import org.jboss.metadata.rar.spec.JCA16MetaData;

/**
 * Create a JCA16MetaData instance from the class annotations.
 * 
 * @author Jeff Zhang</a>
 * @version $Revision: $
 */
public class JCA16MetaDataCreator extends AbstractCreator<ConnectorMetaData>
      implements Creator<Collection<Class<?>>, JCA16MetaData>
{
   /** The Logger. */
   private static final Logger log = Logger.getLogger(JCA16MetaDataCreator.class);
   
   public JCA16MetaDataCreator(AnnotationFinder<AnnotatedElement> finder)
   {
      super(finder);
      //addProcessor(new WebComponentProcessor(finder));
   }

   public JCA16MetaData create(Collection<Class<?>> classes)
   {
      // Don't create meta data for a empty collection
      if(classes == null || classes.isEmpty())
         return null;
      
      // Create meta data
      JCA16MetaData metaData = create();

      processMetaData(classes, metaData);
      
      return metaData;
   }
   
   protected JCA16MetaData create()
   {
      JCA16MetaData metaData = new JCA16MetaData();
      metaData.setVersion("1.6");
      return metaData;
   }
   
   
   protected boolean validateClass(Class<?> clazz)
   {
      boolean trace = log.isTraceEnabled();
      /*
      for(Class<? extends Annotation> annotation : ignoreTypeAnnotations)
      {
         if(finder.getAnnotation(clazz, annotation) != null)
         {
            if(trace)
               log.trace("won't process class: " + clazz + ", because of the type annotation: "+ annotation);
            return false;
         }
      }
      */
      return true;
   }

}
