/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.test;

import java.lang.reflect.Method;

public final class Classes {
    private static final Class[] PRIMITIVE_WRAPPER_MAP = new Class[]{Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class};

    public static Class getPrimitiveWrapper(Class type) {
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException("type is not a primitive class");
        }
        for (int i = 0; i < PRIMITIVE_WRAPPER_MAP.length; i += 2) {
            if (!type.equals(PRIMITIVE_WRAPPER_MAP[i])) continue;
            return PRIMITIVE_WRAPPER_MAP[i + 1];
        }
        throw new IllegalStateException();
    }

    public static boolean isPrimitiveWrapper(Class type) {
        for (int i = 0; i < PRIMITIVE_WRAPPER_MAP.length; i += 2) {
            if (!type.equals(PRIMITIVE_WRAPPER_MAP[i + 1])) continue;
            return true;
        }
        return false;
    }

    public static Method getAttributeGetter(Class cls, String attr) throws NoSuchMethodException {
        StringBuilder buf = new StringBuilder(attr.length() + 3);
        buf.append("get");
        if (Character.isLowerCase(attr.charAt(0))) {
            buf.append(Character.toUpperCase(attr.charAt(0))).append(attr.substring(1));
        } else {
            buf.append(attr);
        }
        try {
            return cls.getMethod(buf.toString(), null);
        }
        catch (NoSuchMethodException e) {
            buf.replace(0, 3, "is");
            return cls.getMethod(buf.toString(), null);
        }
    }
}

