/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ComparePreviousSchemasTestCase {
    private static final Logger LOG = Logger.getLogger(ComparePreviousSchemasTestCase.class.getName());
    private File previous;
    private File current;

    @BeforeClass
    public static void checkCorrectVersion() {
        String cv = System.getProperty("current-version");
        if (cv == null) {
            return;
        }
        String[] current = cv.split("\\.");
        String[] test = System.getProperty("schema-test-version").split("\\.");
        if (current[2].equals("0")) {
            int m2;
            int m1 = Integer.parseInt(current[0]);
            if (m1 == (m2 = Integer.parseInt(test[0]))) {
                m1 = Integer.parseInt(current[1]);
                m2 = Integer.parseInt(test[1]);
                if (m2 + 1 != m1) {
                    ComparePreviousSchemasTestCase.failTestVersion();
                }
            } else if (m2 + 1 != m1) {
                ComparePreviousSchemasTestCase.failTestVersion();
            }
        } else if (!current[0].equals(test[0]) || !current[1].equals(test[1])) {
            ComparePreviousSchemasTestCase.failTestVersion();
        }
    }

    private static void failTestVersion() {
        throw new RuntimeException("last-major-release property in the POM is out of date. This should be set to the previous stable release, so testing can be done to make sure schemas have not been modified");
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static List<Object[]> schemas() throws URISyntaxException {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.addAll(ComparePreviousSchemasTestCase.findFiles("schema", ".xsd"));
        parameters.addAll(ComparePreviousSchemasTestCase.findFiles("dtd", ".dtd"));
        return parameters;
    }

    public ComparePreviousSchemasTestCase(File previous, File current) {
        this.previous = previous;
        this.current = current;
    }

    private static Collection<File[]> findFiles(String dirName, String suffix) {
        try {
            ArrayList<File[]> parameters = new ArrayList<File[]>();
            URL schemaURL = ComparePreviousSchemasTestCase.class.getResource("/" + dirName);
            URI schemaURI = schemaURL.toURI();
            if (schemaURI.isOpaque()) {
                LOG.warning("URI '" + schemaURI + "' is not hierarchical, ignoring");
                return parameters;
            }
            File schemaDir = new File(schemaURL.toURI());
            URL previousSchemaURL = ComparePreviousSchemasTestCase.class.getResource("/previous-release/" + dirName);
            File previousSchemaDir = new File(previousSchemaURL.toURI());
            URL alternateSchemaURL = ComparePreviousSchemasTestCase.class.getResource("/alternate-previous/" + dirName);
            File alternateSchemaDir = alternateSchemaURL != null ? new File(alternateSchemaURL.toURI()) : null;
            for (String name2 : Objects.requireNonNull(schemaDir.list((dir, name) -> {
                File previous = new File(previousSchemaDir, name);
                return name.endsWith(suffix) && previous.exists();
            }))) {
                File alternate;
                File current = new File(schemaDir, name2);
                File previous = new File(previousSchemaDir, name2);
                File file = alternate = alternateSchemaDir != null ? new File(alternateSchemaDir, name2) : null;
                if (alternate != null && alternate.exists()) {
                    parameters.add(new File[]{alternate, current});
                    continue;
                }
                parameters.add(new File[]{previous, current});
            }
            return parameters;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] md5(File file) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            if (file.getName().endsWith("xsd")) {
                String xsd = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8).stream().collect(Collectors.joining("\n"));
                String sb = xsd.replaceAll("<xsd:annotation>[\\s\\S]*?</xsd:annotation>", "").replaceAll("<xs:annotation>[\\s\\S]*?</xs:annotation>", "").replaceAll("<!--[\\s\\S]*?-->", "");
                digest.update(sb.getBytes(StandardCharsets.UTF_8));
            } else {
                try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        digest.update(line.getBytes(StandardCharsets.UTF_8));
                    }
                }
            }
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testMD5() throws IOException {
        Assert.assertArrayEquals((String)("Digest on " + this.previous + " vs " + this.current + " failed"), (byte[])ComparePreviousSchemasTestCase.md5(this.previous), (byte[])ComparePreviousSchemasTestCase.md5(this.current));
    }
}

