package org.jboss.metadata.web.spec;

import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.jboss.metadata.javaee.spec.JavaEEMetaDataConstants;
import org.jboss.xb.annotations.JBossXmlSchema;

/**
 * Web application fragment spec metadata.
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision: 81860 $
 */
@XmlRootElement(name="web-fragment", namespace=JavaEEMetaDataConstants.JAVAEE_NS)
@JBossXmlSchema(
      xmlns={@XmlNs(namespaceURI = JavaEEMetaDataConstants.JAVAEE_NS, prefix = "jee")},
      ignoreUnresolvedFieldOrClass=false,
      namespace=JavaEEMetaDataConstants.JAVAEE_NS,
      elementFormDefault=XmlNsForm.QUALIFIED,
      normalizeSpace=true)
@XmlType(name="web-fragmentType",
      namespace=JavaEEMetaDataConstants.JAVAEE_NS,
      propOrder={"ordering", "descriptionGroup", "name", "distributable", "contextParams", "filters", "filterMappings", "listeners", "servlets",
      "servletMappings", "sessionConfig", "mimeMappings", "welcomeFileList", "errorPages", "jspConfig", "securityConstraints",
      "loginConfig", "securityRoles", "jndiEnvironmentRefsGroup", "messageDestinations", "localEncodings", "ordering"})
public class WebFragment30MetaData extends WebFragmentMetaData
{
   private static final long serialVersionUID = 1;
}
