/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.servlet;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.parser.servlet.Attribute;
import org.jboss.metadata.parser.servlet.Element;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.web.spec.CookieConfigMetaData;

public class CookieConfigMetaDataParser
extends MetaDataElementParser {
    public static CookieConfigMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        CookieConfigMetaData cookieConfig = new CookieConfigMetaData();
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (CookieConfigMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    cookieConfig.setId(value);
                    continue block14;
                }
                default: {
                    throw CookieConfigMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case NAME: {
                    cookieConfig.setName(CookieConfigMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block15;
                }
                case DOMAIN: {
                    cookieConfig.setDomain(CookieConfigMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block15;
                }
                case PATH: {
                    cookieConfig.setPath(CookieConfigMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block15;
                }
                case COMMENT: {
                    cookieConfig.setComment(CookieConfigMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block15;
                }
                case HTTP_ONLY: {
                    if (Boolean.TRUE.equals(Boolean.valueOf(CookieConfigMetaDataParser.getElementText((XMLStreamReader)reader)))) {
                        cookieConfig.setHttpOnly(true);
                        continue block15;
                    }
                    cookieConfig.setHttpOnly(false);
                    continue block15;
                }
                case SECURE: {
                    if (Boolean.TRUE.equals(Boolean.valueOf(CookieConfigMetaDataParser.getElementText((XMLStreamReader)reader)))) {
                        cookieConfig.setSecure(true);
                        continue block15;
                    }
                    cookieConfig.setSecure(false);
                    continue block15;
                }
                case MAX_AGE: {
                    try {
                        cookieConfig.setMaxAge(Integer.valueOf(CookieConfigMetaDataParser.getElementText((XMLStreamReader)reader)));
                        continue block15;
                    }
                    catch (NumberFormatException e) {
                        throw CookieConfigMetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)e);
                    }
                }
            }
            throw CookieConfigMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return cookieConfig;
    }
}

