/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb.jboss;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.creator.ejb.jboss.AbstractEnterpriseBeanProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.JBossResourceAdapterProcessor;
import org.jboss.metadata.annotation.creator.ejb.jboss.TimeoutProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertiesMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDrivenProcessor
extends AbstractEnterpriseBeanProcessor<JBossMessageDrivenBeanMetaData> {
    private static final Pattern pattern = Pattern.compile("\\$\\{([^:}]+)(?:\\:([^}]+))?\\}");

    protected MessageDrivenProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
        this.addTypeProcessor(new JBossResourceAdapterProcessor(finder));
        this.addMethodProcessor(new TimeoutProcessor(finder));
    }

    @Override
    protected JBossMessageDrivenBeanMetaData create(Class<?> beanClass) {
        MessageDriven annotation = this.finder.getAnnotation(beanClass, MessageDriven.class);
        if (annotation == null) {
            return null;
        }
        JBossMessageDrivenBeanMetaData metaData = new JBossMessageDrivenBeanMetaData();
        metaData.setEjbClass(beanClass.getName());
        if (annotation.name().length() > 0) {
            metaData.setEjbName(annotation.name());
        } else {
            metaData.setEjbName(beanClass.getSimpleName());
        }
        if (annotation.description().length() > 0) {
            DescriptionGroupMetaData dg = ProcessorUtils.getDescriptionGroup(annotation.description());
            metaData.setDescriptionGroup(dg);
        }
        if (annotation.mappedName().length() > 0) {
            metaData.setMappedName(annotation.mappedName());
        }
        if (annotation.messageListenerInterface() != Object.class) {
            metaData.setMessagingType(annotation.messageListenerInterface().getName());
        }
        ActivationConfigProperty[] props = annotation.activationConfig();
        ActivationConfigMetaData config = new ActivationConfigMetaData();
        ActivationConfigPropertiesMetaData configProps = new ActivationConfigPropertiesMetaData();
        config.setActivationConfigProperties(configProps);
        for (ActivationConfigProperty prop : props) {
            ActivationConfigPropertyMetaData acp = new ActivationConfigPropertyMetaData();
            acp.setActivationConfigPropertyName(prop.propertyName());
            acp.setValue(this.replaceVariables(prop.propertyName(), prop.propertyValue()));
            configProps.add(acp);
        }
        metaData.setActivationConfig(config);
        return metaData;
    }

    @Override
    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(MessageDriven.class);
    }

    public String replaceVariables(String prop, String expression) {
        Matcher matcher = pattern.matcher(expression);
        while (matcher.find()) {
            String defaultValue;
            String var = matcher.group(1);
            String value = System.getProperty(var, defaultValue = matcher.group(2));
            if (value == null) {
                throw new RuntimeException("could not find value for variable " + var);
            }
            expression = expression.replace(matcher.group(0), value);
            matcher = pattern.matcher(expression);
        }
        return expression;
    }
}

