/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.LifecycleCallbackItem;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
import org.jboss.logging.Logger;
import org.jboss.util.JBossStringBuilder;

public class AbstractLifecycleCallbackItem
implements LifecycleCallbackItem {
    private static final Logger log = Logger.getLogger(AbstractLifecycleCallbackItem.class);
    ControllerState dependentState;
    ControllerState whenRequired;
    String installMethod;
    String uninstallMethod;
    String bean;
    boolean installed;

    public AbstractLifecycleCallbackItem(String bean, ControllerState whenRequired, ControllerState dependentState, String installMethod, String uninstallMethod) {
        this.bean = bean;
        this.whenRequired = whenRequired;
        this.dependentState = dependentState;
        this.installMethod = installMethod;
        this.uninstallMethod = uninstallMethod;
    }

    public ControllerState getDependentState() {
        return this.dependentState;
    }

    public ControllerState getWhenRequired() {
        return this.whenRequired;
    }

    public void install(ControllerContext ctx) throws Exception {
        log.trace((Object)("Invoking install callback '" + this.installMethod + "' on " + this.bean + " for target " + this.bean + " at " + this.whenRequired));
        this.installed = true;
        Controller controller = ctx.getController();
        ControllerContext callbackContext = controller.getContext(this.bean, this.dependentState);
        if (callbackContext instanceof InvokeDispatchContext) {
            try {
                ((InvokeDispatchContext)((Object)callbackContext)).invoke(this.installMethod, new Object[]{ctx}, new String[]{ControllerContext.class.getName()});
            }
            catch (Throwable t) {
                throw new Exception("Error calling callback " + this.bean + " for target context " + ctx.getName(), t);
            }
        } else {
            throw new IllegalArgumentException("Cannot install " + ctx.getName() + ". Lifecycle callback context " + this.bean + " does not implement InvokeDispatchContext");
        }
    }

    public void uninstall(ControllerContext ctx) {
        if (this.installed) {
            log.trace((Object)("Invoking uninstall callback '" + this.installMethod + "' on " + this.bean + " for target " + this.bean + " at " + this.whenRequired));
            this.installed = false;
            Controller controller = ctx.getController();
            ControllerContext callbackContext = controller.getContext(this.bean, this.dependentState);
            if (callbackContext instanceof InvokeDispatchContext) {
                try {
                    ((InvokeDispatchContext)((Object)callbackContext)).invoke(this.uninstallMethod, new Object[]{ctx}, new String[]{ControllerContext.class.getName()});
                }
                catch (Throwable ignored) {
                    log.warn((Object)("Ignored error uninstalling context " + ctx.getName() + "; callback=" + this.bean), ignored);
                }
            } else {
                log.warn((Object)("Cannot uninstall " + ctx.getName() + ". Lifecycle callback context " + this.bean + " does not implement InvokeDispatchContext"));
            }
        }
    }

    public String toString() {
        JBossStringBuilder sb = new JBossStringBuilder("LifecycleCallbackItem-");
        sb.append(this.bean);
        sb.append(":");
        sb.append((Object)this.whenRequired);
        return sb.toString();
    }
}

