/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.spi.helpers;

import java.util.Collections;
import java.util.Set;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.ErrorHandlingMode;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.dependency.spi.helpers.UnmodifiableDependencyInfo;
import org.jboss.dependency.spi.helpers.UnmodifiableScopeInfo;
import org.jboss.util.JBossObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmodifiableControllerContext
extends JBossObject
implements ControllerContext {
    private ControllerContext delegate;

    public UnmodifiableControllerContext(ControllerContext delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        this.delegate = delegate;
    }

    protected ControllerContext getDelegate() {
        return this.delegate;
    }

    @Override
    public Object getName() {
        return this.delegate.getName();
    }

    @Override
    public Set<Object> getAliases() {
        Set<Object> aliases = this.delegate.getAliases();
        return aliases != null ? Collections.unmodifiableSet(aliases) : null;
    }

    @Override
    public DependencyInfo getDependencyInfo() {
        DependencyInfo dependencyInfo = this.delegate.getDependencyInfo();
        return dependencyInfo != null ? new UnmodifiableDependencyInfo(dependencyInfo) : null;
    }

    @Override
    public ScopeInfo getScopeInfo() {
        ScopeInfo scopeInfo = this.delegate.getScopeInfo();
        return scopeInfo != null ? new UnmodifiableScopeInfo(scopeInfo) : null;
    }

    @Override
    public Object getTarget() {
        return this.delegate.getTarget();
    }

    @Override
    public Controller getController() {
        return this.delegate.getController();
    }

    @Override
    public void setController(Controller controller) {
        throw new UnsupportedOperationException("Cannot invoke set on unmodifiable wrapper.");
    }

    @Override
    public void install(ControllerState fromState, ControllerState toState) throws Throwable {
        this.delegate.install(fromState, toState);
    }

    @Override
    public void uninstall(ControllerState fromState, ControllerState toState) {
        this.delegate.uninstall(fromState, toState);
    }

    @Override
    public ControllerState getState() {
        return this.delegate.getState();
    }

    @Override
    public void setState(ControllerState state) {
        throw new UnsupportedOperationException("Cannot invoke set on unmodifiable wrapper.");
    }

    @Override
    public ControllerState getRequiredState() {
        return this.delegate.getRequiredState();
    }

    @Override
    public void setRequiredState(ControllerState state) {
        throw new UnsupportedOperationException("Cannot invoke set on unmodifiable wrapper.");
    }

    @Override
    public ControllerMode getMode() {
        return this.delegate.getMode();
    }

    @Override
    public void setMode(ControllerMode mode) {
        throw new UnsupportedOperationException("Cannot invoke set on unmodifiable wrapper.");
    }

    @Override
    public ErrorHandlingMode getErrorHandlingMode() {
        return this.delegate.getErrorHandlingMode();
    }

    @Override
    public Throwable getError() {
        return this.delegate.getError();
    }

    @Override
    public void setError(Throwable error) {
        throw new UnsupportedOperationException("Cannot invoke set on unmodifiable wrapper.");
    }
}

