/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins.graph;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.plugins.ScopedController;
import org.jboss.dependency.plugins.graph.HierarchyLookupStrategy;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.graph.LookupStrategy;
import org.jboss.dependency.spi.graph.SearchInfo;
import org.jboss.metadata.spi.scope.ScopeKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeKeySearchInfo
implements SearchInfo {
    public static final String SCOPE_KEY = "ScopeKey";
    private ScopeKey scopeKey;
    private Map<String, ?> info;

    public ScopeKeySearchInfo(ScopeKey scopeKey) {
        if (scopeKey == null) {
            throw new IllegalArgumentException("Null scope key");
        }
        this.scopeKey = scopeKey;
    }

    @Override
    public String getType() {
        return SCOPE_KEY;
    }

    @Override
    public Map<String, ?> getInfo() {
        if (this.info == null) {
            this.info = Collections.singletonMap(SCOPE_KEY, this.scopeKey);
        }
        return this.info;
    }

    @Override
    public LookupStrategy getStrategy() {
        return new ScopeKeyLookupStrategy();
    }

    private class ScopeKeyLookupStrategy
    extends HierarchyLookupStrategy {
        private ScopeKeyLookupStrategy() {
        }

        protected ControllerContext getContextInternal(AbstractController controller, Object name, ControllerState state) {
            AbstractController parent = controller.getParentController();
            while (parent != null) {
                controller = parent;
                parent = controller.getParentController();
            }
            AbstractController match = this.findMatchingScopedController(controller);
            if (match != null) {
                return this.getLocalContext(match, name, state);
            }
            return null;
        }

        private AbstractController findMatchingScopedController(AbstractController current) {
            ScopedController scopedController;
            ScopeKey key;
            boolean related = true;
            if (current instanceof ScopedController && (key = (scopedController = (ScopedController)current).getScopeKey()) != null) {
                if (ScopeKeySearchInfo.this.scopeKey.equals((Object)key)) {
                    return current;
                }
                related = false;
                ScopeKey ck = ScopeKeySearchInfo.this.scopeKey;
                int keySize = key.getScopes().size();
                for (int ckSize = ck.getScopes().size(); ck != null && keySize < ckSize; ck = ck.getParent(), --ckSize) {
                    if (!key.isParent(ck)) continue;
                    related = true;
                    break;
                }
            }
            if (related) {
                Set<AbstractController> children = current.getControllers();
                for (AbstractController child : children) {
                    AbstractController found = this.findMatchingScopedController(child);
                    if (found == null) continue;
                    return found;
                }
            }
            return null;
        }
    }
}

