/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.client.spi;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.deployers.client.spi.MissingDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncompleteDeployments
implements Serializable {
    private static final long serialVersionUID = -8413355643801749950L;
    private Map<String, Throwable> deploymentsInError;
    private Collection<String> deploymentsMissingDeployer;
    private Map<String, Throwable> contextsInError;
    private Map<String, Set<MissingDependency>> contextsMissingDependencies;

    public IncompleteDeployments(Map<String, Throwable> deploymentsInError, Collection<String> deploymentsMissingDeployer, Map<String, Throwable> contextsInError, Map<String, Set<MissingDependency>> contextsMissingDependencies) {
        if (deploymentsInError != null && !deploymentsInError.isEmpty()) {
            this.deploymentsInError = new TreeMap<String, Throwable>();
            this.deploymentsInError.putAll(deploymentsInError);
        }
        if (deploymentsMissingDeployer != null && !deploymentsMissingDeployer.isEmpty()) {
            this.deploymentsMissingDeployer = new TreeSet<String>();
            this.deploymentsMissingDeployer.addAll(deploymentsMissingDeployer);
        }
        if (contextsInError != null && !contextsInError.isEmpty()) {
            this.contextsInError = new TreeMap<String, Throwable>();
            this.contextsInError.putAll(contextsInError);
        }
        if (contextsMissingDependencies != null && !contextsMissingDependencies.isEmpty()) {
            this.contextsMissingDependencies = new TreeMap<String, Set<MissingDependency>>();
            this.contextsMissingDependencies.putAll(contextsMissingDependencies);
        }
    }

    public boolean isIncomplete() {
        if (this.deploymentsInError != null) {
            return true;
        }
        if (this.deploymentsMissingDeployer != null) {
            return true;
        }
        if (this.contextsInError != null) {
            return true;
        }
        return this.contextsMissingDependencies != null;
    }

    public boolean isInvalidDeployment(String deploymentName) {
        if (!this.isIncomplete()) {
            return false;
        }
        if (this.matchComponentName(deploymentName, this.getDeploymentsInError().keySet())) {
            return true;
        }
        return this.matchComponentName(deploymentName, this.getDeploymentsMissingDeployer());
    }

    public boolean isInvalidContext(String contextName) {
        if (!this.isIncomplete()) {
            return false;
        }
        if (this.matchComponentName(contextName, this.getContextsInError().keySet())) {
            return true;
        }
        return this.matchComponentName(contextName, this.getContextsMissingDependencies().keySet());
    }

    protected boolean matchComponentName(String componentName, Collection<String> strings) {
        return strings.contains(componentName);
    }

    public Map<String, Throwable> getContextsInError() {
        if (this.contextsInError == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.contextsInError);
    }

    public Map<String, Set<MissingDependency>> getContextsMissingDependencies() {
        if (this.contextsMissingDependencies == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.contextsMissingDependencies);
    }

    public Map<String, Throwable> getDeploymentsInError() {
        if (this.deploymentsInError == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.deploymentsInError);
    }

    public Collection<String> getDeploymentsMissingDeployer() {
        if (this.deploymentsMissingDeployer == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(this.deploymentsMissingDeployer);
    }
}

