/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.api.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Indicates a property that references another ManagedObject
 *  
 * @author Scott.Stark@jboss.org
 * @version $Revision: 64930 $
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ManagementObjectRef
{
   /** An explicit ManagedObject name. If empty, the name is
    * taken from the annotated property.
    * @see {@linkplain ManagedObject#getExternalName()}
    */
   String name() default AnnotationDefaults.EMPTY_STRING;
   /** A qualifier for the name that provides a context to
    * identify the type or scope of the ManagedObject name.
    * @see {@linkplain ManagedObject#getExternalNameType()}
    */
   String type() default AnnotationDefaults.EMPTY_STRING;
}
