/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.plugins.factory;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.config.plugins.property.PropertyConfiguration;
import org.jboss.config.spi.Configuration;
import org.jboss.logging.Logger;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedParameter;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.AnnotationDefaults;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementObjectRef;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ManagementRuntimeRef;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.ManagedOperationImpl;
import org.jboss.managed.plugins.ManagedParameterImpl;
import org.jboss.managed.plugins.WritethroughManagedPropertyImpl;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.managed.spi.factory.ManagedObjectBuilder;
import org.jboss.managed.spi.factory.ManagedObjectPopulator;
import org.jboss.managed.spi.factory.ManagedParameterConstraintsPopulator;
import org.jboss.managed.spi.factory.ManagedParameterConstraintsPopulatorFactory;
import org.jboss.managed.spi.factory.ManagedPropertyConstraintsPopulator;
import org.jboss.managed.spi.factory.ManagedPropertyConstraintsPopulatorFactory;
import org.jboss.managed.spi.factory.RuntimeComponentNameTransformer;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.GenericMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.MetaTypeFactory;
import org.jboss.metatype.api.values.ArrayValueSupport;
import org.jboss.metatype.api.values.GenericValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractManagedObjectFactory
extends ManagedObjectFactory
implements ManagedObjectBuilder,
InstanceClassFactory<Serializable>,
ManagedObjectPopulator<Serializable> {
    private static final Logger log = Logger.getLogger(AbstractManagedObjectFactory.class);
    private static final Configuration configuration;
    public static final GenericMetaType MANAGED_OBJECT_META_TYPE;
    private MetaTypeFactory metaTypeFactory = MetaTypeFactory.getInstance();
    private MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();
    private Map<Class, ManagedObjectBuilder> builders = new WeakHashMap<Class, ManagedObjectBuilder>();
    private Map<Class, InstanceClassFactory> instanceFactories = new WeakHashMap<Class, InstanceClassFactory>();
    private Map<TypeInfo, RuntimeComponentNameTransformer> transformers = new WeakHashMap<TypeInfo, RuntimeComponentNameTransformer>();

    @Override
    public <T extends Serializable> ManagedObject createManagedObject(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        ManagedObject result = this.createSkeletonManagedObject(clazz);
        ManagedObjectPopulator<Serializable> populator = this.getPopulator(clazz);
        populator.createObject(result, clazz);
        return result;
    }

    @Override
    public ManagedObject initManagedObject(Serializable object, String name, String nameType) {
        Class<Serializable> moClass;
        if (object == null) {
            throw new IllegalArgumentException("Null object");
        }
        Class<?> clazz = object.getClass();
        InstanceClassFactory<?> icf = this.getInstanceClassFactory(clazz);
        try {
            moClass = icf.getManagedObjectClass(object);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        ManagedObject result = this.createSkeletonManagedObject(moClass);
        if (result == null) {
            log.debug((Object)("Null ManagedObject created for: " + moClass));
            return null;
        }
        ManagedObjectPopulator<Serializable> populator = this.getPopulator(moClass);
        populator.populateManagedObject(result, object);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBuilder(Class<?> clazz, ManagedObjectBuilder builder) {
        Map<Class, ManagedObjectBuilder> map = this.builders;
        synchronized (map) {
            if (builder == null) {
                this.builders.remove(clazz);
            } else {
                this.builders.put(clazz, builder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Serializable> void setInstanceClassFactory(Class<T> clazz, InstanceClassFactory<T> factory) {
        Map<Class, InstanceClassFactory> map = this.instanceFactories;
        synchronized (map) {
            if (factory == null) {
                this.instanceFactories.remove(clazz);
            } else {
                this.instanceFactories.put(clazz, factory);
            }
        }
    }

    public void setNameTransformers(Class<?> clazz, RuntimeComponentNameTransformer transformer) {
        TypeInfo type = configuration.getTypeInfo(clazz);
        this.setNameTransformers(type, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNameTransformers(TypeInfo type, RuntimeComponentNameTransformer transformer) {
        Map<TypeInfo, RuntimeComponentNameTransformer> map = this.transformers;
        synchronized (map) {
            if (transformer == null) {
                this.transformers.remove(type);
            } else {
                this.transformers.put(type, transformer);
            }
        }
    }

    @Override
    public Class<? extends Serializable> getManagedObjectClass(Serializable instance) {
        return instance.getClass();
    }

    protected <T extends Serializable> ManagedObject createSkeletonManagedObject(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        ManagedObjectBuilder builder = this.getBuilder(clazz);
        return builder.buildManagedObject(clazz);
    }

    @Override
    public ManagedObject buildManagedObject(Class<? extends Serializable> clazz) {
        boolean trace = log.isTraceEnabled();
        BeanInfo beanInfo = configuration.getBeanInfo(clazz);
        ClassInfo classInfo = beanInfo.getClassInfo();
        ManagementObject managementObject = (ManagementObject)classInfo.getUnderlyingAnnotation(ManagementObject.class);
        if (managementObject == null) {
            if (trace) {
                log.trace((Object)("No ManagementObject annotation, skipping ManagedObject for class: " + clazz));
            }
            return null;
        }
        HashMap<String, Annotation> moAnnotations = new HashMap<String, Annotation>();
        moAnnotations.put(ManagementObject.class.getName(), managementObject);
        ManagementObjectID moID = (ManagementObjectID)classInfo.getUnderlyingAnnotation(ManagementObjectID.class);
        if (moID != null) {
            moAnnotations.put(ManagementObjectID.class.getName(), moID);
        }
        boolean isRuntime = managementObject.isRuntime();
        String name = classInfo.getName();
        String nameType = null;
        String attachmentName = classInfo.getName();
        Class<? extends Fields> moFieldsFactory = null;
        Class<? extends ManagedPropertyConstraintsPopulatorFactory> moConstraintsFactory = null;
        Class<? extends ManagedProperty> moPropertyFactory = null;
        if (managementObject != null) {
            ManagementComponent mc;
            name = managementObject.name();
            if (name.length() == 0 || name.equals("%Generated%")) {
                name = classInfo.getName();
            }
            if ((nameType = managementObject.type()).length() == 0) {
                nameType = null;
            }
            if ((attachmentName = managementObject.attachmentName()).length() == 0) {
                attachmentName = classInfo.getName();
            }
            if (!(mc = managementObject.componentType()).equals(AnnotationDefaults.COMP_TYPE)) {
                moAnnotations.put(ManagementComponent.class.getName(), mc);
            }
            moFieldsFactory = managementObject.fieldsFactory();
            moConstraintsFactory = managementObject.constraintsFactory();
            moPropertyFactory = managementObject.propertyFactory();
        }
        if (trace) {
            log.trace((Object)("Building MangedObject(name=" + name + ",nameType=" + nameType + ",attachmentName=" + attachmentName + ",isRuntime=" + isRuntime + ")"));
        }
        ManagementProperties propertyType = ManagementProperties.ALL;
        if (managementObject != null) {
            propertyType = managementObject.properties();
        }
        HashSet<ManagedProperty> properties = new HashSet<ManagedProperty>();
        Set propertyInfos = beanInfo.getProperties();
        if (propertyInfos != null && !propertyInfos.isEmpty()) {
            for (PropertyInfo propertyInfo : propertyInfos) {
                boolean includeProperty;
                if ("class".equals(propertyInfo.getName())) continue;
                ManagementProperty managementProperty = (ManagementProperty)propertyInfo.getUnderlyingAnnotation(ManagementProperty.class);
                ManagementObjectID id = (ManagementObjectID)propertyInfo.getUnderlyingAnnotation(ManagementObjectID.class);
                ManagementObjectRef ref = (ManagementObjectRef)propertyInfo.getUnderlyingAnnotation(ManagementObjectRef.class);
                ManagementRuntimeRef runtimeRef = (ManagementRuntimeRef)propertyInfo.getUnderlyingAnnotation(ManagementRuntimeRef.class);
                HashMap<String, Annotation> propAnnotations = new HashMap<String, Annotation>();
                if (managementProperty != null) {
                    propAnnotations.put(ManagementProperty.class.getName(), managementProperty);
                }
                if (id != null) {
                    propAnnotations.put(ManagementObjectID.class.getName(), id);
                    nameType = id.type();
                }
                if (ref != null) {
                    propAnnotations.put(ManagementObjectRef.class.getName(), ref);
                }
                if (runtimeRef != null) {
                    propAnnotations.put(ManagementRuntimeRef.class.getName(), runtimeRef);
                }
                boolean bl = includeProperty = propertyType == ManagementProperties.ALL;
                if (managementProperty != null) {
                    boolean bl2 = includeProperty = !managementProperty.ignored();
                }
                if (includeProperty) {
                    Class<? extends ManagedProperty> factory;
                    TypeInfo typeInfo;
                    Fields fields = null;
                    if (managementProperty != null) {
                        Class<? extends Fields> factory2 = moFieldsFactory;
                        if (factory2 == ManagementProperty.NULL_FIELDS_FACTORY.class) {
                            factory2 = managementProperty.fieldsFactory();
                        }
                        if (factory2 != ManagementProperty.NULL_FIELDS_FACTORY.class) {
                            try {
                                fields = factory2.newInstance();
                            }
                            catch (Exception e) {
                                log.debug((Object)"Failed to created Fields", (Throwable)e);
                            }
                        }
                    }
                    if (fields == null) {
                        fields = new DefaultFieldsImpl();
                    }
                    if (propertyInfo instanceof Serializable) {
                        Serializable info = (Serializable)Serializable.class.cast(propertyInfo);
                        fields.setField("propertyInfo", info);
                    }
                    String propertyName = propertyInfo.getName();
                    if (managementProperty != null) {
                        propertyName = managementProperty.name();
                    }
                    if (propertyName.length() == 0) {
                        propertyName = propertyInfo.getName();
                    }
                    fields.setField("name", (Serializable)((Object)propertyName));
                    String mappedName = propertyInfo.getName();
                    if (managementProperty != null) {
                        mappedName = managementProperty.mappedName();
                    }
                    if (mappedName.length() == 0) {
                        mappedName = propertyInfo.getName();
                    }
                    fields.setField("mappedName", (Serializable)((Object)mappedName));
                    String description = "%Generated%";
                    if (managementProperty != null) {
                        description = managementProperty.description();
                    }
                    if (description.equals("%Generated%")) {
                        description = propertyName;
                    }
                    fields.setField("description", (Serializable)((Object)description));
                    if (trace) {
                        log.trace((Object)("Building MangedProperty(name=" + propertyName + ",mappedName=" + mappedName + ") ,annotations=" + propAnnotations));
                    }
                    boolean mandatory = false;
                    if (managementProperty != null) {
                        mandatory = managementProperty.mandatory();
                    }
                    if (mandatory) {
                        fields.setField("mandatory", Boolean.TRUE);
                    }
                    boolean managed = false;
                    if (managementProperty != null) {
                        managed = managementProperty.managed();
                    }
                    Object metaType = managed ? ((typeInfo = propertyInfo.getType()).isArray() || typeInfo.isCollection() ? new ArrayMetaType(1, (MetaType)MANAGED_OBJECT_META_TYPE) : MANAGED_OBJECT_META_TYPE) : this.metaTypeFactory.resolve(propertyInfo.getType());
                    fields.setField("metaType", (Serializable)metaType);
                    if (!propAnnotations.isEmpty()) {
                        fields.setField("annotations", propAnnotations);
                    }
                    try {
                        ManagedPropertyConstraintsPopulator populator;
                        Class<? extends ManagedPropertyConstraintsPopulatorFactory> factoryClass = moConstraintsFactory;
                        if (factoryClass == ManagementProperty.NULL_CONSTRAINTS.class && managementProperty != null) {
                            factoryClass = managementProperty.constraintsFactory();
                        }
                        if ((populator = (factory = factoryClass.newInstance()).newInstance()) != null) {
                            populator.populateManagedProperty(clazz, propertyInfo, fields);
                        }
                    }
                    catch (Exception e) {
                        log.debug((Object)("Failed to populate constraints for: " + propertyInfo), (Throwable)e);
                    }
                    ManagedProperty property = null;
                    if (managementProperty != null) {
                        factory = moPropertyFactory;
                        if (factory == ManagementProperty.NULL_PROPERTY_FACTORY.class) {
                            factory = managementProperty.propertyFactory();
                        }
                        if (factory != ManagementProperty.NULL_PROPERTY_FACTORY.class) {
                            property = this.getManagedProperty(factory, fields);
                        }
                    }
                    if (property == null) {
                        property = this.createDefaultManagedProperty(fields);
                    }
                    properties.add(property);
                    continue;
                }
                if (!trace) continue;
                log.trace((Object)("Ignoring property: " + propertyInfo));
            }
        }
        HashSet<ManagedOperation> operations = new HashSet<ManagedOperation>();
        Set methodInfos = beanInfo.getMethods();
        if (methodInfos != null && !methodInfos.isEmpty()) {
            for (MethodInfo methodInfo : methodInfos) {
                ManagementOperation managementOp = (ManagementOperation)methodInfo.getUnderlyingAnnotation(ManagementOperation.class);
                if (managementOp == null) continue;
                ManagedOperation op = this.getManagedOperation(methodInfo, managementOp);
                operations.add(op);
            }
        }
        ManagedObjectImpl result = new ManagedObjectImpl(name, properties);
        result.setAnnotations(moAnnotations);
        if (nameType != null) {
            result.setNameType(nameType);
        }
        if (attachmentName != null) {
            result.setAttachmentName(attachmentName);
        }
        if (operations.size() > 0) {
            result.setOperations(operations);
        }
        for (ManagedProperty property : properties) {
            property.setManagedObject(result);
        }
        return result;
    }

    protected ManagedProperty createDefaultManagedProperty(Fields fields) {
        return new WritethroughManagedPropertyImpl(fields, this.metaValueFactory, this);
    }

    @Override
    public void createObject(ManagedObject managedObject, Class<? extends Serializable> clazz) {
        if (managedObject == null) {
            throw new IllegalArgumentException("Null managed object");
        }
        if (!(managedObject instanceof ManagedObjectImpl)) {
            throw new IllegalStateException("Unable to create object " + managedObject.getClass().getName());
        }
        ManagedObjectImpl managedObjectImpl = (ManagedObjectImpl)managedObject;
        Serializable object = this.createUnderlyingObject(managedObjectImpl, clazz);
        this.populateManagedObject(managedObject, object);
    }

    @Override
    public void populateManagedObject(ManagedObject managedObject, Serializable object) {
        if (!(managedObject instanceof ManagedObjectImpl)) {
            throw new IllegalStateException("Unable to populate managed object " + managedObject.getClass().getName());
        }
        ManagedObjectImpl managedObjectImpl = (ManagedObjectImpl)managedObject;
        managedObjectImpl.setAttachment(object);
        this.populateValues(managedObjectImpl, object);
    }

    protected Serializable createUnderlyingObject(ManagedObjectImpl managedObject, Class<? extends Serializable> clazz) {
        BeanInfo beanInfo = configuration.getBeanInfo(clazz);
        try {
            Object result = beanInfo.newInstance();
            return (Serializable)Serializable.class.cast(result);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to create new object for " + managedObject + " clazz=" + clazz, t);
        }
    }

    protected void populateValues(ManagedObjectImpl managedObject, Serializable object) {
        Class<Serializable> moClass;
        InstanceClassFactory<?> icf = this.getInstanceClassFactory(object.getClass());
        try {
            moClass = icf.getManagedObjectClass(object);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        BeanInfo beanInfo = configuration.getBeanInfo(moClass);
        Object componentName = null;
        Map<String, ManagedProperty> properties = managedObject.getProperties();
        if (properties != null && properties.size() > 0) {
            for (ManagedProperty property : properties.values()) {
                ManagementRuntimeRef runtimeRef;
                Map<String, Annotation> annotations;
                MetaValue value = icf.getValue(beanInfo, property, object);
                if (value != null) {
                    property.setField("value", (Serializable)value);
                }
                if ((annotations = property.getAnnotations()) == null) continue;
                ManagementObjectID id = (ManagementObjectID)annotations.get(ManagementObjectID.class.getName());
                if (id != null) {
                    if (value == null || !value.getMetaType().isSimple()) {
                        log.warn((Object)("Cannot create String name from non-Simple property: " + property + ", value=" + value));
                        continue;
                    }
                    SimpleValue svalue = (SimpleValue)value;
                    String name = "" + svalue.getValue();
                    managedObject.setName(name);
                }
                if ((runtimeRef = (ManagementRuntimeRef)annotations.get(ManagementRuntimeRef.class.getName())) == null || (componentName = icf.getComponentName(beanInfo, property, object, value)) != null || icf == this) continue;
                componentName = this.getComponentName(beanInfo, property, object, value);
            }
        }
        if (componentName == null) {
            componentName = icf.getComponentName(null, null, object, null);
        }
        managedObject.setComponentName(componentName);
    }

    protected String getPropertyName(ManagedProperty property) {
        String name = property.getMappedName();
        if (name == null) {
            property.getName();
        }
        return name;
    }

    @Override
    public Object getComponentName(BeanInfo beanInfo, ManagedProperty property, Serializable object, MetaValue value) {
        String name;
        PropertyInfo propertyInfo;
        ManagementRuntimeRef componentRef;
        if (beanInfo != null && property != null && value != null && (componentRef = (ManagementRuntimeRef)(propertyInfo = beanInfo.getProperty(name = this.getPropertyName(property))).getUnderlyingAnnotation(ManagementRuntimeRef.class)) != null) {
            Object original = this.metaValueFactory.unwrap(value, propertyInfo.getType());
            try {
                Class<? extends RuntimeComponentNameTransformer> tClass = componentRef.transformer();
                RuntimeComponentNameTransformer transformer = tClass != ManagementRuntimeRef.DEFAULT_NAME_TRANSFORMER.class ? this.getComponentNameTransformer(configuration.getTypeInfo(tClass)) : this.getComponentNameTransformer(propertyInfo.getType());
                return transformer != null ? transformer.transform(original) : original;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
        return null;
    }

    @Override
    public MetaValue getValue(BeanInfo beanInfo, ManagedProperty property, Serializable object) {
        ArrayMetaType arrayType;
        Object value;
        String name = this.getPropertyName(property);
        PropertyInfo propertyInfo = beanInfo.getProperty(name);
        try {
            value = propertyInfo.get((Object)object);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error getting property " + name + " for " + object.getClass().getName(), t);
        }
        if (value == null) {
            return null;
        }
        MetaType propertyType = property.getMetaType();
        if (MANAGED_OBJECT_META_TYPE == propertyType) {
            if (!(value instanceof Serializable)) {
                throw new IllegalStateException("Object is not serializable: " + value.getClass().getName());
            }
            ManagementObjectRef ref = (ManagementObjectRef)property.getAnnotations().get(ManagementObjectRef.class.getName());
            String moName = ref != null ? ref.name() : value.getClass().getName();
            String moNameType = ref != null ? ref.type() : "";
            ManagedObject mo = this.initManagedObject((Serializable)value, moName, moNameType);
            return new GenericValueSupport(MANAGED_OBJECT_META_TYPE, (Serializable)mo);
        }
        if (propertyType.isArray() && MANAGED_OBJECT_META_TYPE == (arrayType = (ArrayMetaType)ArrayMetaType.class.cast(propertyType)).getElementType()) {
            Collection cvalue = this.getAsCollection(value);
            ArrayMetaType moType = new ArrayMetaType(1, (MetaType)MANAGED_OBJECT_META_TYPE);
            ArrayValueSupport moArrayValue = new ArrayValueSupport(moType);
            ArrayList<GenericValueSupport> tmp = new ArrayList<GenericValueSupport>();
            for (Object element : cvalue) {
                ManagedObject mo = this.initManagedObject((Serializable)element, null, null);
                tmp.add(new GenericValueSupport(MANAGED_OBJECT_META_TYPE, (Serializable)mo));
            }
            GenericValueSupport[] mos = new GenericValueSupport[tmp.size()];
            tmp.toArray(mos);
            moArrayValue.setValue((Object)mos);
            return moArrayValue;
        }
        return this.metaValueFactory.create(value, propertyInfo.getType());
    }

    @Override
    public void setValue(BeanInfo beanInfo, ManagedProperty property, Serializable object, MetaValue value) {
        String name = this.getPropertyName(property);
        PropertyInfo propertyInfo = beanInfo.getProperty(name);
        Object plainValue = this.metaValueFactory.unwrap(value, propertyInfo.getType());
        try {
            propertyInfo.set((Object)object, plainValue);
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    protected ManagedOperation getManagedOperation(MethodInfo methodInfo, ManagementOperation opAnnotation) {
        String name = methodInfo.getName();
        String description = opAnnotation.description();
        ManagedOperation.Impact impact = opAnnotation.impact();
        ManagementParameter[] params = opAnnotation.params();
        ParameterInfo[] paramInfo = methodInfo.getParameters();
        TypeInfo returnInfo = methodInfo.getReturnType();
        MetaType returnType = this.metaTypeFactory.resolve(returnInfo);
        ArrayList<ManagedParameterImpl> mparams = new ArrayList<ManagedParameterImpl>();
        Class<? extends ManagedParameterConstraintsPopulatorFactory> opConstraintsFactor = opAnnotation.constraintsFactory();
        if (paramInfo != null) {
            for (int i = 0; i < paramInfo.length; ++i) {
                ParameterInfo pinfo = paramInfo[i];
                String pname = pinfo.getName();
                String pdescription = null;
                ManagementParameter mpa = null;
                if (i < params.length) {
                    mpa = params[i];
                    if (!mpa.name().equals("")) {
                        pname = mpa.name();
                    }
                    if (!mpa.description().equals("")) {
                        pdescription = mpa.description();
                    }
                }
                if (pname == null) {
                    pname = "arg#" + i;
                }
                DefaultFieldsImpl fields = new DefaultFieldsImpl(pname);
                if (pdescription != null) {
                    fields.setField("description", (Serializable)((Object)pdescription));
                }
                MetaType metaType = this.metaTypeFactory.resolve(pinfo.getParameterType());
                fields.setField("metaType", (Serializable)metaType);
                try {
                    ManagedParameterConstraintsPopulatorFactory factory;
                    ManagedParameterConstraintsPopulator populator;
                    Class<? extends ManagedParameterConstraintsPopulatorFactory> factoryClass = opConstraintsFactor;
                    if (factoryClass == ManagementParameter.NULL_CONSTRAINTS.class && mpa != null) {
                        factoryClass = mpa.constraintsFactory();
                    }
                    if ((populator = (factory = factoryClass.newInstance()).newInstance()) != null) {
                        populator.populateManagedParameter(name, pinfo, fields);
                    }
                }
                catch (Exception e) {
                    log.debug((Object)("Failed to populate constraints for: " + pinfo), (Throwable)e);
                }
                ManagedParameterImpl mp = new ManagedParameterImpl(fields);
                mparams.add(mp);
            }
        }
        ManagedParameter[] parameters = new ManagedParameter[mparams.size()];
        mparams.toArray(parameters);
        return new ManagedOperationImpl(name, description, impact, parameters, returnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ManagedObjectBuilder getBuilder(Class<?> clazz) {
        Map<Class, ManagedObjectBuilder> map = this.builders;
        synchronized (map) {
            ManagedObjectBuilder builder = this.builders.get(clazz);
            if (builder != null) {
                return builder;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Serializable> InstanceClassFactory<T> getInstanceClassFactory(Class<T> clazz) {
        Map<Class, InstanceClassFactory> map = this.instanceFactories;
        synchronized (map) {
            InstanceClassFactory factory = this.instanceFactories.get(clazz);
            if (factory != null) {
                return factory;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RuntimeComponentNameTransformer getComponentNameTransformer(TypeInfo type) throws Throwable {
        Map<TypeInfo, RuntimeComponentNameTransformer> map = this.transformers;
        synchronized (map) {
            RuntimeComponentNameTransformer transformer = this.transformers.get(type);
            if (transformer != null) {
                return transformer;
            }
            TypeInfo rcntType = configuration.getTypeInfo(RuntimeComponentNameTransformer.class);
            if (rcntType.isAssignableFrom(type)) {
                BeanInfo beanInfo = configuration.getBeanInfo(type);
                RuntimeComponentNameTransformer newTransformer = (RuntimeComponentNameTransformer)beanInfo.newInstance();
                this.transformers.put(type, newTransformer);
                return newTransformer;
            }
            return null;
        }
    }

    protected ManagedObjectPopulator<Serializable> getPopulator(Class<?> clazz) {
        ManagedObjectBuilder builder = this.getBuilder(clazz);
        if (builder instanceof ManagedObjectPopulator) {
            return (ManagedObjectPopulator)((Object)builder);
        }
        return this;
    }

    protected Collection getAsCollection(Object value) {
        if (value.getClass().isArray()) {
            return Arrays.asList(value);
        }
        if (value instanceof Collection) {
            return (Collection)Collection.class.cast(value);
        }
        return null;
    }

    protected ManagedProperty getManagedProperty(Class<? extends ManagedProperty> factory, Fields fields) {
        ManagedProperty property = null;
        try {
            Class[] sig = new Class[]{Fields.class};
            Constructor<? extends ManagedProperty> ctor = factory.getConstructor(sig);
            Object[] args = new Object[]{fields};
            property = ctor.newInstance(args);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to create ManagedProperty", (Throwable)e);
        }
        return property;
    }

    static {
        MANAGED_OBJECT_META_TYPE = new GenericMetaType(ManagedObject.class.getName(), ManagedObject.class.getName());
        configuration = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

            @Override
            public Configuration run() {
                return new PropertyConfiguration();
            }
        });
    }
}

