/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reliance.drools.core;

import java.io.IOException;
import java.io.InputStream;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.StatelessSession;
import org.drools.rule.Package;
import org.jboss.beans.metadata.api.annotations.Constructor;
import org.jboss.beans.metadata.api.annotations.FromContext;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.api.annotations.Install;
import org.jboss.beans.metadata.api.annotations.Uninstall;
import org.jboss.logging.Logger;
import org.jboss.reliance.drools.core.PackageWrapper;

public class RuleBaseBean
implements RuleBase {
    protected Logger log = Logger.getLogger(this.getClass());
    private String name;
    private RuleBaseConfiguration configuration;
    private RuleBase ruleBase;

    @Constructor
    public RuleBaseBean(@Inject(fromContext=FromContext.NAME) String name) {
        this.name = name;
    }

    public void setConfiguration(RuleBaseConfiguration configuration) {
        this.configuration = configuration;
    }

    public void create() throws Exception {
        this.ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)this.configuration);
    }

    public void destroy() {
        this.ruleBase = null;
    }

    protected boolean matchPackage(PackageWrapper pw) {
        return pw.getName() == null || pw.getName().equals(this.name);
    }

    @Install(whenRequired="Start", cardinality="1..n")
    public void addPackage(PackageWrapper pckg) throws Exception {
        if (this.matchPackage(pckg)) {
            this.ruleBase.addPackage(pckg.getPackage());
        }
    }

    @Uninstall(whenRequired="Start")
    public void removePackage(PackageWrapper pckg) {
        if (this.matchPackage(pckg)) {
            this.ruleBase.removePackage(pckg.getPackage().getName());
        }
    }

    public StatelessSession newStatelessSession() {
        return this.ruleBase.newStatelessSession();
    }

    public StatefulSession newStatefulSession() {
        return this.ruleBase.newStatefulSession();
    }

    public StatefulSession newStatefulSession(boolean keepReference) {
        return this.ruleBase.newStatefulSession(keepReference);
    }

    public StatefulSession newStatefulSession(InputStream inputStream) throws IOException, ClassNotFoundException {
        return this.ruleBase.newStatefulSession(inputStream);
    }

    public StatefulSession newStatefulSession(InputStream inputStream, boolean b) throws IOException, ClassNotFoundException {
        return this.ruleBase.newStatefulSession(inputStream);
    }

    public Package[] getPackages() {
        return this.ruleBase.getPackages();
    }

    public Package getPackage(String name) {
        return this.ruleBase.getPackage(name);
    }

    public void addPackage(Package pckg) throws Exception {
        this.ruleBase.addPackage(pckg);
    }

    public void removePackage(String name) {
        this.ruleBase.removePackage(name);
    }

    public void removeRule(String name, String ruleName) {
        this.ruleBase.removeRule(name, ruleName);
    }

    public void removeFunction(String packageName, String functionName) {
        this.ruleBase.removeFunction(packageName, functionName);
    }

    public void removeProcess(String id) {
        this.ruleBase.removeProcess(id);
    }

    public StatefulSession[] getStatefulSessions() {
        return this.ruleBase.getStatefulSessions();
    }
}

