/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reliance.drools.deployer;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.rule.Package;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.reliance.drools.core.PackageWrapper;
import org.jboss.reliance.drools.deployer.SecurityActions;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DRLFileDeployer
extends AbstractVFSParsingDeployer<BeanMetaData> {
    private static final String BEANS = "-beans.";
    private static final String DSL = "-beans..dsl";
    private PackageBuilderConfiguration configuration;

    public DRLFileDeployer() {
        super(BeanMetaData.class);
        this.setSuffix(BEANS + this.getFileSuffix());
    }

    public void setConfiguration(PackageBuilderConfiguration configuration) {
        this.configuration = configuration;
    }

    protected String getFileSuffix() {
        return "drl";
    }

    protected Reader getDRLReader(InputStream inputStream) {
        return new InputStreamReader(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BeanMetaData parse(VFSDeploymentUnit unit, VirtualFile file, BeanMetaData root) throws Exception {
        PackageBuilder builder;
        block7: {
            String name = file.getName();
            VirtualFile dslFile = unit.getMetaDataFile(name.replaceFirst(this.getSuffix(), DSL));
            builder = new PackageBuilder(this.configuration);
            Reader drlReader = this.getDRLReader(SecurityActions.openStream(file));
            try {
                if (dslFile != null) {
                    InputStreamReader dslReader = new InputStreamReader(SecurityActions.openStream(dslFile));
                    try {
                        builder.addPackageFromDrl(drlReader, (Reader)dslReader);
                        break block7;
                    }
                    finally {
                        dslFile.closeStreams();
                    }
                }
                builder.addPackageFromDrl(drlReader);
            }
            finally {
                file.closeStreams();
            }
        }
        BeanMetaDataBuilder beanBuilder = BeanMetaDataBuilderFactory.createBuilder((String)(unit.getName() + "_PackageWrapper"), (String)PackageWrapper.class.getName());
        beanBuilder.addCreateParameter(Package.class.getName(), (Object)builder.getPackage());
        return beanBuilder.getBeanMetaData();
    }
}

