/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reliance.drools.core.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.drools.FactHandle;
import org.drools.ObjectFilter;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.base.ClassObjectFilter;
import org.jboss.reliance.drools.core.RuleDependencyCheck;
import org.jboss.reliance.drools.core.aspects.DisableFireAllRules;
import org.jboss.reliance.drools.core.aspects.FireAllRulesAfter;
import org.jboss.reliance.drools.core.security.PermissionCheck;
import org.jboss.reliance.drools.core.security.Role;
import org.jboss.reliance.identity.Identity;

public class RuleBasedIdentity
extends Identity
implements RuleDependencyCheck {
    private StatefulSession securityContext;
    private RuleBase securityRules;

    public void create() {
        super.create();
        if (this.securityContext == null && this.securityRules != null) {
            this.securityContext = this.securityRules.newStatefulSession(false);
        }
        if (this.securityContext == null) {
            log.warn((Object)"No security rule base available - please install a RuleBase if permission checks are required.");
        }
    }

    protected void postAuthenticate() {
        super.postAuthenticate();
        StatefulSession securityContext = this.getSecurityContext();
        if (securityContext != null) {
            for (Principal p : this.getSubject().getPrincipals()) {
                if (!(p instanceof Group) || !"Roles".equals(p.getName())) continue;
                Enumeration e = ((Group)p).members();
                while (e.hasMoreElements()) {
                    Principal role = (Principal)e.nextElement();
                    securityContext.insert((Object)new Role(role.getName()));
                }
            }
            securityContext.insert((Object)this.getPrincipal());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DisableFireAllRules
    public boolean canResolve(Object name, Object action, Object ... arg) {
        StatefulSession securityContext = this.getSecurityContext();
        if (securityContext == null) {
            return false;
        }
        ArrayList<FactHandle> handles = new ArrayList<FactHandle>();
        PermissionCheck check = new PermissionCheck(name, action);
        StatefulSession statefulSession = securityContext;
        synchronized (statefulSession) {
            try {
                handles.add(securityContext.insert((Object)check));
                for (int i = 0; i < arg.length; ++i) {
                    if (i == 0 && arg[0] instanceof Collection) {
                        for (Object value : (Collection)arg[i]) {
                            if (securityContext.getFactHandle(value) != null) continue;
                            handles.add(securityContext.insert(value));
                        }
                        continue;
                    }
                    handles.add(securityContext.insert(arg[i]));
                }
                securityContext.fireAllRules();
            }
            finally {
                for (FactHandle handle : handles) {
                    securityContext.retract(handle);
                }
            }
        }
        return check.isGranted();
    }

    protected void unAuthenticate() {
        StatefulSession securityContext = this.getSecurityContext();
        if (securityContext != null) {
            Iterator iter = securityContext.iterateObjects((ObjectFilter)new ClassObjectFilter(Role.class));
            while (iter.hasNext()) {
                securityContext.retract(securityContext.getFactHandle(iter.next()));
            }
        }
        super.unAuthenticate();
    }

    public boolean addRole(String role) {
        StatefulSession securityContext;
        if (super.addRole(role) && (securityContext = this.getSecurityContext()) != null) {
            securityContext.insert((Object)new Role(role));
            return true;
        }
        return false;
    }

    public void removeRole(String role) {
        StatefulSession securityContext = this.getSecurityContext();
        if (securityContext != null) {
            Iterator iter = securityContext.iterateObjects((ObjectFilter)new ClassObjectFilter(Role.class));
            while (iter.hasNext()) {
                Role r = (Role)iter.next();
                if (!r.getName().equals(role)) continue;
                FactHandle fh = securityContext.getFactHandle((Object)r);
                securityContext.retract(fh);
                break;
            }
        }
        super.removeRole(role);
    }

    public StatefulSession getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(StatefulSession securityContext) {
        this.securityContext = securityContext;
    }

    public void setSecurityRules(RuleBase securityRules) {
        this.securityRules = securityRules;
    }

    @FireAllRulesAfter
    public boolean login() {
        return super.login();
    }

    @FireAllRulesAfter
    public void quietLogin() {
        super.quietLogin();
    }

    @FireAllRulesAfter
    public void authenticate() throws LoginException {
        super.authenticate();
    }

    @FireAllRulesAfter
    public void authenticate(LoginContext loginContext) throws LoginException {
        super.authenticate(loginContext);
    }

    @FireAllRulesAfter
    public boolean isLoggedIn() {
        return super.isLoggedIn();
    }

    @FireAllRulesAfter
    public boolean isLoggedIn(boolean attemptLogin) {
        return super.isLoggedIn(attemptLogin);
    }
}

