/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap;

import java.util.ServiceLoader;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.eap.EAP7ServerMigrationProvider;
import org.jboss.migration.wfly10.WildFly10ServerMigration;

public class EAP7ServerMigrations {
    private static final ServiceLoader<EAP7ServerMigrationProvider> SERVICE_LOADER = ServiceLoader.load(EAP7ServerMigrationProvider.class);

    private EAP7ServerMigrations() {
    }

    static WildFly10ServerMigration getMigrationFrom(Server sourceServer) {
        ServerMigrationLogger.ROOT_LOGGER.debugf("Retrieving server migration for source %s", sourceServer.getClass());
        for (EAP7ServerMigrationProvider serverMigrationProvider : SERVICE_LOADER) {
            if (!serverMigrationProvider.getSourceType().isInstance(sourceServer)) continue;
            ServerMigrationLogger.ROOT_LOGGER.debugf("Found server migration for source %s: %s", sourceServer.getClass(), serverMigrationProvider.getClass());
            return serverMigrationProvider.getServerMigration();
        }
        ServerMigrationLogger.ROOT_LOGGER.debugf("Failed to retrieve server migration for source %s", sourceServer.getClass());
        return null;
    }
}

