/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.management.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.migration.wfly10.WildFly10Server;
import org.jboss.migration.wfly10.config.management.DeploymentsManagement;
import org.jboss.migration.wfly10.config.management.ExtensionsManagement;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.HostsManagement;
import org.jboss.migration.wfly10.config.management.InterfacesManagement;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.ProfilesManagement;
import org.jboss.migration.wfly10.config.management.ServerGroupsManagement;
import org.jboss.migration.wfly10.config.management.SocketBindingGroupsManagement;
import org.jboss.migration.wfly10.config.management.impl.AbstractManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.impl.DeploymentsManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.ExtensionsManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.HostsManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.InterfacesManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.ProfilesManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.ServerGroupsManagementImpl;
import org.jboss.migration.wfly10.config.management.impl.SocketBindingGroupsManagementImpl;
import org.jboss.migration.wfly10.config.task.ServerConfigurationMigration;
import org.wildfly.core.embedded.EmbeddedProcessFactory;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.core.embedded.HostController;

public class EmbeddedHostControllerConfiguration
extends AbstractManageableServerConfiguration
implements HostControllerConfiguration {
    private final String domainConfig;
    private final String hostConfig;
    private HostController hostController;
    private final DeploymentsManagement deploymentsManagement;
    private final ExtensionsManagement extensionsManagement;
    private final InterfacesManagement interfacesManagement;
    private final HostsManagement hostsManagement;
    private final ProfilesManagement profilesManagement;
    private final ServerGroupsManagement serverGroupsManagement;
    private final SocketBindingGroupsManagement socketBindingGroupsManagement;

    protected EmbeddedHostControllerConfiguration(String domainConfig, String hostConfig, WildFly10Server server) {
        super(server);
        this.domainConfig = domainConfig;
        this.extensionsManagement = new ExtensionsManagementImpl(null, (ManageableServerConfiguration)this){

            @Override
            public Set<String> getSubsystems() throws IOException {
                HashSet<String> subsystems = new HashSet<String>();
                for (String profile : EmbeddedHostControllerConfiguration.this.getProfilesManagement().getResourceNames()) {
                    subsystems.addAll(EmbeddedHostControllerConfiguration.this.profilesManagement.getProfileManagement(profile).getSubsystemsManagement().getResourceNames());
                }
                return subsystems;
            }
        };
        this.hostConfig = hostConfig;
        this.deploymentsManagement = new DeploymentsManagementImpl(null, this);
        this.hostsManagement = new HostsManagementImpl(null, this);
        this.profilesManagement = new ProfilesManagementImpl(null, this);
        this.serverGroupsManagement = new ServerGroupsManagementImpl(null, this);
        this.interfacesManagement = new InterfacesManagementImpl(null, this);
        this.socketBindingGroupsManagement = new SocketBindingGroupsManagementImpl(null, this);
    }

    @Override
    protected ModelControllerClient startConfiguration() {
        ArrayList<String> cmds = new ArrayList<String>();
        if (this.domainConfig != null) {
            cmds.add("--domain-config=" + this.domainConfig);
        }
        if (this.hostConfig != null) {
            cmds.add("--host-config=" + this.hostConfig);
        }
        cmds.add("--admin-only");
        this.hostController = EmbeddedProcessFactory.createHostController((String)this.getServer().getBaseDir().toString(), null, null, (String[])cmds.toArray(new String[cmds.size()]));
        try {
            this.hostController.start();
        }
        catch (EmbeddedProcessStartException e) {
            throw new RuntimeException(e);
        }
        return this.hostController.getModelControllerClient();
    }

    @Override
    protected void stopConfiguration() {
        this.hostController.stop();
        this.hostController = null;
    }

    @Override
    public DeploymentsManagement getDeploymentsManagement() {
        return this.deploymentsManagement;
    }

    @Override
    public ExtensionsManagement getExtensionsManagement() {
        return this.extensionsManagement;
    }

    @Override
    public HostsManagement getHostsManagement() {
        return this.hostsManagement;
    }

    @Override
    public InterfacesManagement getInterfacesManagement() {
        return this.interfacesManagement;
    }

    @Override
    public ProfilesManagement getProfilesManagement() {
        return this.profilesManagement;
    }

    @Override
    public SocketBindingGroupsManagement getSocketBindingGroupsManagement() {
        return this.socketBindingGroupsManagement;
    }

    @Override
    public ServerGroupsManagement getServerGroupsManagement() {
        return this.serverGroupsManagement;
    }

    public static class HostConfigFileMigrationFactory
    implements ServerConfigurationMigration.ManageableConfigurationProvider {
        public HostControllerConfiguration getManageableConfiguration(Path configFile, WildFly10Server server) {
            return new EmbeddedHostControllerConfiguration(null, configFile.getFileName().toString(), server);
        }
    }

    public static class DomainConfigFileMigrationFactory
    implements ServerConfigurationMigration.ManageableConfigurationProvider {
        public HostControllerConfiguration getManageableConfiguration(Path configFile, WildFly10Server server) {
            return new EmbeddedHostControllerConfiguration(configFile.getFileName().toString(), null, server);
        }
    }
}

