/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task;

import org.jboss.migration.core.Server;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.console.ConsoleWrapper;
import org.jboss.migration.core.console.UserConfirmationServerMigrationTask;
import org.jboss.migration.core.env.SkippableByEnvServerMigrationTask;
import org.jboss.migration.wfly10.WildFly10Server;
import org.jboss.migration.wfly10.config.task.DomainConfigurationsMigration;
import org.jboss.migration.wfly10.config.task.HostConfigurationsMigration;
import org.jboss.migration.wfly10.config.task.ServerMigration;

public class DomainMigration<S extends Server>
implements ServerMigration.SubtaskFactory<S> {
    public static final String DOMAIN = "domain";
    public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("domain").build();
    private final DomainConfigurationsMigration<S, ?> domainConfigurationsMigration;
    private final HostConfigurationsMigration<S, ?> hostConfigurationsMigration;

    public DomainMigration(Builder<S> builder) {
        this.domainConfigurationsMigration = ((Builder)builder).domainConfigurationsMigration;
        this.hostConfigurationsMigration = ((Builder)builder).hostConfigurationsMigration;
    }

    @Override
    public ServerMigrationTask getTask(S source, WildFly10Server target) {
        ServerMigrationTask task = new ServerMigrationTask((Server)source, target){
            final /* synthetic */ Server val$source;
            final /* synthetic */ WildFly10Server val$target;
            {
                this.val$source = server;
                this.val$target = wildFly10Server;
            }

            public ServerMigrationTaskName getName() {
                return SERVER_MIGRATION_TASK_NAME;
            }

            public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                ConsoleWrapper consoleWrapper = context.getServerMigrationContext().getConsoleWrapper();
                consoleWrapper.printf("%n", new Object[0]);
                context.getLogger().infof("Domain migration starting...", new Object[0]);
                if (DomainMigration.this.domainConfigurationsMigration != null) {
                    context.execute(DomainMigration.this.domainConfigurationsMigration.getServerMigrationTask(this.val$source, this.val$target, this.val$target.getDomainConfigurationDir()));
                }
                if (DomainMigration.this.hostConfigurationsMigration != null) {
                    context.execute(DomainMigration.this.hostConfigurationsMigration.getServerMigrationTask(this.val$source, this.val$target, this.val$target.getDomainConfigurationDir()));
                }
                consoleWrapper.printf("%n", new Object[0]);
                context.getLogger().infof("Domain migration done.", new Object[0]);
                return context.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
            }
        };
        return new SkippableByEnvServerMigrationTask((ServerMigrationTask)new UserConfirmationServerMigrationTask(task, "Setup the target's domain?"), "domain.skip");
    }

    public static class Builder<S extends Server> {
        private DomainConfigurationsMigration<S, ?> domainConfigurationsMigration;
        private HostConfigurationsMigration<S, ?> hostConfigurationsMigration;

        public Builder<S> domainConfigurations(DomainConfigurationsMigration<S, ?> domainConfigurationsMigration) {
            this.domainConfigurationsMigration = domainConfigurationsMigration;
            return this;
        }

        public Builder<S> hostConfigurations(HostConfigurationsMigration<S, ?> hostConfigurationsMigration) {
            this.hostConfigurationsMigration = hostConfigurationsMigration;
            return this;
        }

        public DomainMigration<S> build() {
            return new DomainMigration(this);
        }
    }

    public static interface EnvironmentProperties {
        public static final String PROPERTIES_PREFIX = "domain.";
        public static final String SKIP = "domain.skip";
    }
}

