/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.console.ConsoleWrapper;
import org.jboss.migration.wfly10.WildFly10Server;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.task.factory.ManageableServerConfigurationTaskFactory;

public class ServerConfigurationMigration<S, T extends ManageableServerConfiguration> {
    public static final String MIGRATION_REPORT_TASK_ATTR_SOURCE = "source";
    private final String configType;
    protected final XMLConfigurationProvider xmlConfigurationProvider;
    protected final ManageableConfigurationProvider<T> manageableConfigurationProvider;
    protected final List<ManageableServerConfigurationTaskFactory<S, T>> manageableConfigurationSubtaskFactories;
    protected final List<XMLConfigurationSubtaskFactory<S>> xmlConfigurationSubtaskFactories;

    protected ServerConfigurationMigration(Builder builder) {
        this.configType = builder.configType;
        this.xmlConfigurationProvider = builder.xmlConfigurationProvider;
        this.manageableConfigurationProvider = builder.manageableConfigurationProvider;
        this.manageableConfigurationSubtaskFactories = Collections.unmodifiableList(builder.manageableConfigurationSubtaskFactories.factories);
        this.xmlConfigurationSubtaskFactories = Collections.unmodifiableList(builder.xmlConfigurationSubtaskFactories);
    }

    public String getConfigType() {
        return this.configType;
    }

    protected ServerMigrationTask getServerMigrationTask(final S source, final Path targetConfigDir, final WildFly10Server target) {
        final ServerMigrationTaskName taskName = new ServerMigrationTaskName.Builder(this.getConfigType() + "-configuration").addAttribute(MIGRATION_REPORT_TASK_ATTR_SOURCE, source.toString()).build();
        return new ServerMigrationTask(){

            public ServerMigrationTaskName getName() {
                return taskName;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                ConsoleWrapper consoleWrapper = context.getServerMigrationContext().getConsoleWrapper();
                consoleWrapper.printf("%n", new Object[0]);
                context.getLogger().infof("Migrating %s configuration %s", (Object)ServerConfigurationMigration.this.getConfigType(), source);
                Path xmlConfigurationPath = ServerConfigurationMigration.this.xmlConfigurationProvider.getXMLConfiguration(source, targetConfigDir, target, context);
                for (XMLConfigurationSubtaskFactory<Object> xMLConfigurationSubtaskFactory : ServerConfigurationMigration.this.xmlConfigurationSubtaskFactories) {
                    ServerMigrationTask serverMigrationTask = xMLConfigurationSubtaskFactory.getTask(source, xmlConfigurationPath, target);
                    if (serverMigrationTask == null) continue;
                    context.execute(serverMigrationTask);
                }
                if (ServerConfigurationMigration.this.manageableConfigurationProvider != null) {
                    Object configurationManagement = ServerConfigurationMigration.this.manageableConfigurationProvider.getManageableConfiguration(xmlConfigurationPath, target);
                    context.getLogger().debugf("Starting target configuration %s", (Object)xmlConfigurationPath.getFileName());
                    configurationManagement.start();
                    try {
                        for (ManageableServerConfigurationTaskFactory manageableServerConfigurationTaskFactory : ServerConfigurationMigration.this.manageableConfigurationSubtaskFactories) {
                            ServerMigrationTask subtask = manageableServerConfigurationTaskFactory.getTask(source, configurationManagement);
                            if (subtask == null) continue;
                            context.execute(subtask);
                        }
                    }
                    finally {
                        configurationManagement.stop();
                    }
                }
                return ServerMigrationTaskResult.SUCCESS;
            }
        };
    }

    public static class ManageableServerConfigurationTaskFactories<S, T extends ManageableServerConfiguration> {
        private final List<ManageableServerConfigurationTaskFactory<S, T>> factories = new ArrayList<ManageableServerConfigurationTaskFactory<S, T>>();

        public List<ManageableServerConfigurationTaskFactory<S, T>> getFactories() {
            return Collections.unmodifiableList(this.factories);
        }

        public void add(ManageableServerConfigurationTaskFactory<S, T> subtaskFactory) {
            this.factories.add(subtaskFactory);
        }

        public void addAll(Collection<ManageableServerConfigurationTaskFactory<S, T>> subtaskFactories) {
            this.factories.addAll(subtaskFactories);
        }
    }

    public static class Builder<S, T extends ManageableServerConfiguration> {
        private final String configType;
        private final XMLConfigurationProvider xmlConfigurationProvider;
        private ManageableConfigurationProvider<T> manageableConfigurationProvider;
        private final ManageableServerConfigurationTaskFactories<S, T> manageableConfigurationSubtaskFactories;
        private final List<XMLConfigurationSubtaskFactory<S>> xmlConfigurationSubtaskFactories;

        public Builder(String configType, XMLConfigurationProvider xmlConfigurationProvider) {
            this.configType = configType;
            this.xmlConfigurationProvider = xmlConfigurationProvider;
            this.manageableConfigurationSubtaskFactories = new ManageableServerConfigurationTaskFactories();
            this.xmlConfigurationSubtaskFactories = new ArrayList<XMLConfigurationSubtaskFactory<S>>();
        }

        public Builder<S, T> manageableConfigurationProvider(ManageableConfigurationProvider<T> manageableConfigurationProvider) {
            this.manageableConfigurationProvider = manageableConfigurationProvider;
            return this;
        }

        public Builder<S, T> subtask(ManageableServerConfigurationTaskFactory<S, T> subtaskFactory) {
            this.manageableConfigurationSubtaskFactories.add(subtaskFactory);
            return this;
        }

        public Builder<S, T> subtask(XMLConfigurationSubtaskFactory<S> subtaskFactory) {
            this.xmlConfigurationSubtaskFactories.add(subtaskFactory);
            return this;
        }

        public ServerConfigurationMigration<S, T> build() {
            return new ServerConfigurationMigration(this);
        }
    }

    public static interface XMLConfigurationSubtaskFactory<S> {
        public ServerMigrationTask getTask(S var1, Path var2, WildFly10Server var3);
    }

    public static interface ManageableConfigurationProvider<T extends ManageableServerConfiguration> {
        public T getManageableConfiguration(Path var1, WildFly10Server var2) throws Exception;
    }

    public static interface XMLConfigurationProvider<S> {
        public Path getXMLConfiguration(S var1, Path var2, WildFly10Server var3, ServerMigrationTaskContext var4) throws Exception;
    }
}

