/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task;

import java.nio.file.Path;
import java.util.Collection;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.ServerMigrationFailedException;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.console.BasicResultHandlers;
import org.jboss.migration.core.console.ConsoleWrapper;
import org.jboss.migration.core.console.UserConfirmation;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.WildFly10Server;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.task.ServerConfigurationMigration;

public class ServerConfigurationsMigration<S extends Server, C, T extends ManageableServerConfiguration> {
    private final ServerMigrationTaskName taskName;
    private final SourceConfigurations<S, C> sourceConfigurations;
    private final ServerConfigurationMigration<C, T> configFileMigration;

    public ServerConfigurationsMigration(SourceConfigurations<S, C> sourceConfigurations, ServerConfigurationMigration<C, T> configFileMigration) {
        this.sourceConfigurations = sourceConfigurations;
        this.configFileMigration = configFileMigration;
        this.taskName = new ServerMigrationTaskName.Builder(configFileMigration.getConfigType() + "-configurations").build();
    }

    public ServerMigrationTask getServerMigrationTask(S source, WildFly10Server target, Path targetConfigDir) {
        return new Task<C, T>(this.getServerMigrationTaskName(), this.sourceConfigurations.getConfigurations(source, target), target, targetConfigDir, this.configFileMigration);
    }

    protected ServerMigrationTaskName getServerMigrationTaskName() {
        return this.taskName;
    }

    public static interface SourceConfigurations<S extends Server, C> {
        public Collection<C> getConfigurations(S var1, WildFly10Server var2);
    }

    protected static class Task<S, T extends ManageableServerConfiguration>
    implements ServerMigrationTask {
        private final ServerMigrationTaskName name;
        private final Collection<S> sourceConfigs;
        private final Path targetConfigDir;
        private final WildFly10Server target;
        private final ServerConfigurationMigration<S, T> configFileMigration;

        protected Task(ServerMigrationTaskName name, Collection<S> sourceConfigs, WildFly10Server target, Path targetConfigDir, ServerConfigurationMigration<S, T> configFileMigration) {
            this.name = name;
            this.sourceConfigs = sourceConfigs;
            this.targetConfigDir = targetConfigDir;
            this.target = target;
            this.configFileMigration = configFileMigration;
        }

        public ServerMigrationTaskName getName() {
            return this.name;
        }

        public ServerMigrationTaskResult run(ServerMigrationTaskContext taskContext) throws Exception {
            ServerMigrationContext serverMigrationContext = taskContext.getServerMigrationContext();
            ConsoleWrapper consoleWrapper = serverMigrationContext.getConsoleWrapper();
            consoleWrapper.printf("%n", new Object[0]);
            taskContext.getLogger().infof("Retrieving source's %s configurations...", (Object)this.configFileMigration.getConfigType());
            if (!this.sourceConfigs.isEmpty()) {
                for (S sourceConfig : this.sourceConfigs) {
                    taskContext.getLogger().infof("%s", sourceConfig);
                }
            } else {
                taskContext.getLogger().infof("No source's %s configurations found.", (Object)this.configFileMigration.getConfigType());
            }
            if (serverMigrationContext.isInteractive()) {
                BasicResultHandlers.UserConfirmation resultHandler = new BasicResultHandlers.UserConfirmation();
                new UserConfirmation(consoleWrapper, "Migrate all configurations?", ServerMigrationLogger.ROOT_LOGGER.yesNo(), (UserConfirmation.ResultHandler)resultHandler).execute();
                switch (resultHandler.getResult()) {
                    case NO: {
                        this.confirmAllConfigs(this.sourceConfigs, this.targetConfigDir, this.target, taskContext);
                        break;
                    }
                    case YES: {
                        this.migrateAllConfigs(this.sourceConfigs, this.targetConfigDir, this.target, taskContext);
                        break;
                    }
                    case ERROR: {
                        return this.run(taskContext);
                    }
                    default: {
                        throw new ServerMigrationFailedException("unexpected user interaction result");
                    }
                }
            } else {
                this.migrateAllConfigs(this.sourceConfigs, this.targetConfigDir, this.target, taskContext);
            }
            return taskContext.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
        }

        protected void migrateAllConfigs(Collection<S> sourceConfigs, Path targetConfigDir, WildFly10Server target, ServerMigrationTaskContext taskContext) throws Exception {
            for (S sourceConfig : sourceConfigs) {
                taskContext.execute(this.configFileMigration.getServerMigrationTask(sourceConfig, targetConfigDir, target));
            }
        }

        protected void confirmAllConfigs(Collection<S> sourceConfigs, Path targetConfigDir, WildFly10Server target, ServerMigrationTaskContext taskContext) throws Exception {
            for (S sourceConfig : sourceConfigs) {
                this.confirmConfig(sourceConfig, targetConfigDir, target, taskContext);
            }
        }

        protected void confirmConfig(final S sourceConfig, final Path targetConfigDir, final WildFly10Server target, final ServerMigrationTaskContext taskContext) throws Exception {
            UserConfirmation.ResultHandler resultHandler = new UserConfirmation.ResultHandler(){

                public void onNo() throws Exception {
                }

                public void onYes() throws Exception {
                    taskContext.execute(Task.this.configFileMigration.getServerMigrationTask(sourceConfig, targetConfigDir, target));
                }

                public void onError() throws Exception {
                    Task.this.confirmConfig(sourceConfig, targetConfigDir, target, taskContext);
                }
            };
            ConsoleWrapper consoleWrapper = taskContext.getServerMigrationContext().getConsoleWrapper();
            new UserConfirmation(consoleWrapper, "Migrate configuration " + sourceConfig + " ?", ServerMigrationLogger.ROOT_LOGGER.yesNo(), resultHandler).execute();
        }
    }
}

