/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.wfly10.WildFly10Server;
import org.jboss.migration.wfly10.WildFly10ServerMigration;

public class ServerMigration<S extends Server>
implements WildFly10ServerMigration<S> {
    protected final List<SubtaskFactory<S>> subtaskFactories;

    public ServerMigration(Builder<S> builder) {
        this.subtaskFactories = Collections.unmodifiableList(((Builder)builder).subtaskFactories);
    }

    @Override
    public ServerMigrationTaskResult run(S source, WildFly10Server target, ServerMigrationTaskContext context) {
        for (SubtaskFactory<S> subtaskFactory : this.subtaskFactories) {
            ServerMigrationTask subtask = subtaskFactory.getTask(source, target);
            if (subtask == null) continue;
            context.execute(subtask);
        }
        return context.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
    }

    public static class Builder<S extends Server> {
        private final List<SubtaskFactory<S>> subtaskFactories = new ArrayList<SubtaskFactory<S>>();

        public Builder subtask(SubtaskFactory<S> subtaskFactory) {
            this.subtaskFactories.add(subtaskFactory);
            return this;
        }

        public ServerMigration<S> build() {
            return new ServerMigration(this);
        }
    }

    public static interface SubtaskFactory<S extends Server> {
        public ServerMigrationTask getTask(S var1, WildFly10Server var2);
    }
}

