/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.executor.SubsystemsManagementSubtaskExecutor;

public class AddSubsystemConfigSubtask<S>
implements SubsystemsManagementSubtaskExecutor<S> {
    protected final String subsystemName;

    public AddSubsystemConfigSubtask(String subsystemName) {
        this.subsystemName = subsystemName;
    }

    @Override
    public void executeSubtasks(S source, final SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context) throws Exception {
        final String configName = subsystemsManagement.getResourcePathAddress(this.subsystemName).toCLIStyleString();
        final ServerMigrationTaskName taskName = new ServerMigrationTaskName.Builder("add-subsystem-config").addAttribute("name", configName).build();
        ServerMigrationTask task = new ServerMigrationTask(){

            public ServerMigrationTaskName getName() {
                return taskName;
            }

            public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                if (subsystemsManagement.getResource(AddSubsystemConfigSubtask.this.subsystemName) != null) {
                    context.getLogger().infof("Skipped adding subsystem config %s, already exists.", (Object)configName);
                    return ServerMigrationTaskResult.SKIPPED;
                }
                context.getLogger().debugf("Adding subsystem config %s...", (Object)configName);
                AddSubsystemConfigSubtask.this.addSubsystem(subsystemsManagement, context);
                context.getLogger().infof("Subsystem config %s added.", (Object)configName);
                return ServerMigrationTaskResult.SUCCESS;
            }
        };
        context.execute(task);
    }

    protected void addSubsystem(SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context) throws Exception {
        ModelNode op = Util.createAddOperation((PathAddress)subsystemsManagement.getResourcePathAddress(this.subsystemName));
        subsystemsManagement.getServerConfiguration().executeManagementOperation(op);
    }
}

