/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.Extension;
import org.jboss.migration.wfly10.config.task.subsystem.ExtensionBuilder;

public class SubsystemsMigration<S> {
    public static final ServerMigrationTaskName MANAGEMENT_RESOURCES_SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("subsystems-management-resources").build();
    private final List<Extension> supportedExtensions;

    protected SubsystemsMigration(Builder builder) {
        this.supportedExtensions = Collections.unmodifiableList(builder.supportedExtensions);
    }

    public ServerMigrationTask getSubsystemsManagementTask(S source, final SubsystemsManagement subsystemsManagement) {
        return new ServerMigrationTask(){

            public ServerMigrationTaskName getName() {
                return MANAGEMENT_RESOURCES_SERVER_MIGRATION_TASK_NAME;
            }

            public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                context.getLogger().infof("Subsystems resources migration starting...", new Object[0]);
                SubsystemsMigration.this.migrateExtensions(subsystemsManagement, context);
                context.getLogger().infof("Subsystems resources migration done.", new Object[0]);
                return ServerMigrationTaskResult.SUCCESS;
            }
        };
    }

    protected void migrateExtensions(SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context) throws IOException {
        List<Extension> extensionsToMigrate = this.getMigrationExtensions(context.getServerMigrationContext().getMigrationEnvironment());
        for (Extension extensionToMigrate : extensionsToMigrate) {
            extensionToMigrate.migrate(subsystemsManagement, context);
        }
    }

    private List<Extension> getMigrationExtensions(MigrationEnvironment migrationEnvironment) {
        List removedByEnv = migrationEnvironment.getPropertyAsList("extensions.remove");
        if (removedByEnv == null || removedByEnv.isEmpty()) {
            return this.supportedExtensions;
        }
        ArrayList<Extension> migrationExtensions = new ArrayList<Extension>();
        for (Extension supportedExtension : this.supportedExtensions) {
            if (removedByEnv.contains(supportedExtension.getName())) continue;
            migrationExtensions.add(supportedExtension);
        }
        return migrationExtensions;
    }

    public static class Builder<S> {
        private final List<Extension> supportedExtensions = new ArrayList<Extension>();

        public Builder<S> addExtension(Extension extension) {
            this.supportedExtensions.add(extension);
            return this;
        }

        public Builder<S> addExtension(ExtensionBuilder extensionBuilder) {
            this.supportedExtensions.add(extensionBuilder.build());
            return this;
        }

        public Builder<S> addExtensions(Collection<Extension> extensions) {
            this.supportedExtensions.addAll(extensions);
            return this;
        }

        public SubsystemsMigration<S> build() {
            return new SubsystemsMigration(this);
        }
    }
}

