/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.ejb3;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.UpdateSubsystemTaskFactory;

public class DefinePassivationDisabledCacheRef
implements UpdateSubsystemTaskFactory.SubtaskFactory {
    public static final DefinePassivationDisabledCacheRef INSTANCE = new DefinePassivationDisabledCacheRef();
    public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("setup-default-sfsb-passivation-disabled-cache").build();
    private static final String DEFAULT_SFSB_CACHE_ATTR_NAME = "default-sfsb-cache";
    private static final String DEFAULT_SFSB_PASSIVATION_DISABLED_CACHE_ATTR_NAME = "default-sfsb-passivation-disabled-cache";

    private DefinePassivationDisabledCacheRef() {
    }

    @Override
    public ServerMigrationTask getServerMigrationTask(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement) {
        return new UpdateSubsystemTaskFactory.Subtask(config, subsystem, subsystemsManagement){

            public ServerMigrationTaskName getName() {
                return SERVER_MIGRATION_TASK_NAME;
            }

            @Override
            protected ServerMigrationTaskResult run(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context, TaskEnvironment taskEnvironment) throws Exception {
                if (config == null) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                if (!config.hasDefined(DefinePassivationDisabledCacheRef.DEFAULT_SFSB_CACHE_ATTR_NAME) || config.hasDefined(DefinePassivationDisabledCacheRef.DEFAULT_SFSB_PASSIVATION_DISABLED_CACHE_ATTR_NAME)) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                PathAddress subsystemPathAddress = subsystemsManagement.getResourcePathAddress(subsystem.getName());
                ManageableServerConfiguration configurationManagement = subsystemsManagement.getServerConfiguration();
                String defaultSFSBCache = config.get(DefinePassivationDisabledCacheRef.DEFAULT_SFSB_CACHE_ATTR_NAME).asString();
                ModelNode op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)subsystemPathAddress);
                op.get("name").set(DefinePassivationDisabledCacheRef.DEFAULT_SFSB_PASSIVATION_DISABLED_CACHE_ATTR_NAME);
                op.get("value").set(defaultSFSBCache);
                configurationManagement.executeManagementOperation(op);
                context.getLogger().infof("EJB3 subsystem's 'default-sfsb-passivation-disabled-cache' attribute set to %s.", (Object)defaultSFSBCache);
                return ServerMigrationTaskResult.SUCCESS;
            }
        };
    }
}

